package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link BanQuerySpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BanQuerySpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code BanQuerySpec.create()}.
 */
@Generated(from = "BanQuerySpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class BanQuerySpec implements BanQuerySpecGenerator {
  private final @Nullable String reason;
  private final @Nullable Integer deleteMessageDays;

  private BanQuerySpec() {
    this.reason = null;
    this.deleteMessageDays = null;
  }

  private BanQuerySpec(
      @Nullable String reason,
      @Nullable Integer deleteMessageDays) {
    this.reason = reason;
    this.deleteMessageDays = deleteMessageDays;
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code deleteMessageDays} attribute
   */
  @Override
  public @Nullable Integer deleteMessageDays() {
    return deleteMessageDays;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BanQuerySpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final BanQuerySpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return validate(new BanQuerySpec(value, this.deleteMessageDays));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BanQuerySpec#deleteMessageDays() deleteMessageDays} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deleteMessageDays (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final BanQuerySpec withDeleteMessageDays(@Nullable Integer value) {
    if (Objects.equals(this.deleteMessageDays, value)) return this;
    return validate(new BanQuerySpec(this.reason, value));
  }

  /**
   * This instance is equal to all instances of {@code BanQuerySpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BanQuerySpec
        && equalTo(0, (BanQuerySpec) another);
  }

  private boolean equalTo(int synthetic, BanQuerySpec another) {
    return Objects.equals(reason, another.reason)
        && Objects.equals(deleteMessageDays, another.deleteMessageDays);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code deleteMessageDays}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + Objects.hashCode(deleteMessageDays);
    return h;
  }

  /**
   * Prints the immutable value {@code BanQuerySpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BanQuerySpec{"
        + "reason=" + reason
        + ", deleteMessageDays=" + deleteMessageDays
        + "}";
  }

  private static final BanQuerySpec INSTANCE = validate(new BanQuerySpec());

  /**
   * Returns the default immutable singleton value of {@code BanQuerySpec}
   * @return An immutable instance of BanQuerySpec
   */
  public static BanQuerySpec create() {
    return INSTANCE;
  }

  private static BanQuerySpec validate(BanQuerySpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link BanQuerySpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BanQuerySpec instance
   */
  static BanQuerySpec copyOf(BanQuerySpecGenerator instance) {
    if (instance instanceof BanQuerySpec) {
      return (BanQuerySpec) instance;
    }
    return BanQuerySpec.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link BanQuerySpec BanQuerySpec}.
   * <pre>
   * BanQuerySpec.builder()
   *    .reason(String | null) // nullable {@link BanQuerySpec#reason() reason}
   *    .deleteMessageDays(Integer | null) // nullable {@link BanQuerySpec#deleteMessageDays() deleteMessageDays}
   *    .build();
   * </pre>
   * @return A new BanQuerySpec builder
   */
  public static BanQuerySpec.Builder builder() {
    return new BanQuerySpec.Builder();
  }

  /**
   * Builds instances of type {@link BanQuerySpec BanQuerySpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BanQuerySpecGenerator", generator = "Immutables")
  public static final class Builder {
    private String reason;
    private Integer deleteMessageDays;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BanQuerySpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BanQuerySpec instance) {
      return from((BanQuerySpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code BanQuerySpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(BanQuerySpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      Integer deleteMessageDaysValue = instance.deleteMessageDays();
      if (deleteMessageDaysValue != null) {
        deleteMessageDays(deleteMessageDaysValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link BanQuerySpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Initializes the value for the {@link BanQuerySpec#deleteMessageDays() deleteMessageDays} attribute.
     * @param deleteMessageDays The value for deleteMessageDays (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder deleteMessageDays(@Nullable Integer deleteMessageDays) {
      this.deleteMessageDays = deleteMessageDays;
      return this;
    }

    /**
     * Builds a new {@link BanQuerySpec BanQuerySpec}.
     * @return An immutable instance of BanQuerySpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BanQuerySpec build() {
      return BanQuerySpec.validate(new BanQuerySpec(reason, deleteMessageDays));
    }
  }
}
