package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.audit.ActionType;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link AuditLogQuerySpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code AuditLogQuerySpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code AuditLogQuerySpec.create()}.
 */
@Generated(from = "AuditLogQuerySpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class AuditLogQuerySpec implements AuditLogQuerySpecGenerator {
  private final @Nullable Snowflake userId;
  private final @Nullable ActionType actionType;
  private final @Nullable Snowflake before;
  private final @Nullable Integer limit;

  private AuditLogQuerySpec() {
    this.userId = null;
    this.actionType = null;
    this.before = null;
    this.limit = null;
  }

  private AuditLogQuerySpec(
      @Nullable Snowflake userId,
      @Nullable ActionType actionType,
      @Nullable Snowflake before,
      @Nullable Integer limit) {
    this.userId = userId;
    this.actionType = actionType;
    this.before = before;
    this.limit = limit;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @Override
  public @Nullable Snowflake userId() {
    return userId;
  }

  /**
   * @return The value of the {@code actionType} attribute
   */
  @Override
  public @Nullable ActionType actionType() {
    return actionType;
  }

  /**
   * @return The value of the {@code before} attribute
   */
  @Override
  public @Nullable Snowflake before() {
    return before;
  }

  /**
   * @return The value of the {@code limit} attribute
   */
  @Override
  public @Nullable Integer limit() {
    return limit;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuditLogQuerySpec#userId() userId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final AuditLogQuerySpec withUserId(@Nullable Snowflake value) {
    if (this.userId == value) return this;
    return validate(new AuditLogQuerySpec(value, this.actionType, this.before, this.limit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuditLogQuerySpec#actionType() actionType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for actionType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final AuditLogQuerySpec withActionType(@Nullable ActionType value) {
    if (this.actionType == value) return this;
    return validate(new AuditLogQuerySpec(this.userId, value, this.before, this.limit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuditLogQuerySpec#before() before} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for before (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final AuditLogQuerySpec withBefore(@Nullable Snowflake value) {
    if (this.before == value) return this;
    return validate(new AuditLogQuerySpec(this.userId, this.actionType, value, this.limit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuditLogQuerySpec#limit() limit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for limit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final AuditLogQuerySpec withLimit(@Nullable Integer value) {
    if (Objects.equals(this.limit, value)) return this;
    return validate(new AuditLogQuerySpec(this.userId, this.actionType, this.before, value));
  }

  /**
   * This instance is equal to all instances of {@code AuditLogQuerySpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AuditLogQuerySpec
        && equalTo(0, (AuditLogQuerySpec) another);
  }

  private boolean equalTo(int synthetic, AuditLogQuerySpec another) {
    return Objects.equals(userId, another.userId)
        && Objects.equals(actionType, another.actionType)
        && Objects.equals(before, another.before)
        && Objects.equals(limit, another.limit);
  }

  /**
   * Computes a hash code from attributes: {@code userId}, {@code actionType}, {@code before}, {@code limit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(userId);
    h += (h << 5) + Objects.hashCode(actionType);
    h += (h << 5) + Objects.hashCode(before);
    h += (h << 5) + Objects.hashCode(limit);
    return h;
  }

  /**
   * Prints the immutable value {@code AuditLogQuerySpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AuditLogQuerySpec{"
        + "userId=" + userId
        + ", actionType=" + actionType
        + ", before=" + before
        + ", limit=" + limit
        + "}";
  }

  private static final AuditLogQuerySpec INSTANCE = validate(new AuditLogQuerySpec());

  /**
   * Returns the default immutable singleton value of {@code AuditLogQuerySpec}
   * @return An immutable instance of AuditLogQuerySpec
   */
  public static AuditLogQuerySpec create() {
    return INSTANCE;
  }

  private static AuditLogQuerySpec validate(AuditLogQuerySpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link AuditLogQuerySpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AuditLogQuerySpec instance
   */
  static AuditLogQuerySpec copyOf(AuditLogQuerySpecGenerator instance) {
    if (instance instanceof AuditLogQuerySpec) {
      return (AuditLogQuerySpec) instance;
    }
    return AuditLogQuerySpec.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link AuditLogQuerySpec AuditLogQuerySpec}.
   * <pre>
   * AuditLogQuerySpec.builder()
   *    .userId(discord4j.common.util.Snowflake | null) // nullable {@link AuditLogQuerySpec#userId() userId}
   *    .actionType(discord4j.core.object.audit.ActionType | null) // nullable {@link AuditLogQuerySpec#actionType() actionType}
   *    .before(discord4j.common.util.Snowflake | null) // nullable {@link AuditLogQuerySpec#before() before}
   *    .limit(Integer | null) // nullable {@link AuditLogQuerySpec#limit() limit}
   *    .build();
   * </pre>
   * @return A new AuditLogQuerySpec builder
   */
  public static AuditLogQuerySpec.Builder builder() {
    return new AuditLogQuerySpec.Builder();
  }

  /**
   * Builds instances of type {@link AuditLogQuerySpec AuditLogQuerySpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AuditLogQuerySpecGenerator", generator = "Immutables")
  public static final class Builder {
    private Snowflake userId;
    private ActionType actionType;
    private Snowflake before;
    private Integer limit;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AuditLogQuerySpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AuditLogQuerySpec instance) {
      return from((AuditLogQuerySpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code AuditLogQuerySpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(AuditLogQuerySpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      Snowflake userIdValue = instance.userId();
      if (userIdValue != null) {
        userId(userIdValue);
      }
      ActionType actionTypeValue = instance.actionType();
      if (actionTypeValue != null) {
        actionType(actionTypeValue);
      }
      Snowflake beforeValue = instance.before();
      if (beforeValue != null) {
        before(beforeValue);
      }
      Integer limitValue = instance.limit();
      if (limitValue != null) {
        limit(limitValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AuditLogQuerySpec#userId() userId} attribute.
     * @param userId The value for userId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder userId(@Nullable Snowflake userId) {
      this.userId = userId;
      return this;
    }

    /**
     * Initializes the value for the {@link AuditLogQuerySpec#actionType() actionType} attribute.
     * @param actionType The value for actionType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder actionType(@Nullable ActionType actionType) {
      this.actionType = actionType;
      return this;
    }

    /**
     * Initializes the value for the {@link AuditLogQuerySpec#before() before} attribute.
     * @param before The value for before (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder before(@Nullable Snowflake before) {
      this.before = before;
      return this;
    }

    /**
     * Initializes the value for the {@link AuditLogQuerySpec#limit() limit} attribute.
     * @param limit The value for limit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder limit(@Nullable Integer limit) {
      this.limit = limit;
      return this;
    }

    /**
     * Builds a new {@link AuditLogQuerySpec AuditLogQuerySpec}.
     * @return An immutable instance of AuditLogQuerySpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AuditLogQuerySpec build() {
      return AuditLogQuerySpec.validate(new AuditLogQuerySpec(userId, actionType, before, limit));
    }
  }
}
