package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.audit.ActionType;
import discord4j.core.object.entity.Guild;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link AuditLogQueryFluxGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code AuditLogQueryFlux.of()}.
 */
@Generated(from = "AuditLogQueryFluxGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class AuditLogQueryFlux extends AuditLogQueryFluxGenerator {
  private final @Nullable Snowflake userId;
  private final @Nullable ActionType actionType;
  private final @Nullable Snowflake before;
  private final @Nullable Integer limit;
  private final Guild guild;

  private AuditLogQueryFlux(Guild guild) {
    this.guild = Objects.requireNonNull(guild, "guild");
    this.userId = null;
    this.actionType = null;
    this.before = null;
    this.limit = null;
  }

  private AuditLogQueryFlux(
      @Nullable Snowflake userId,
      @Nullable ActionType actionType,
      @Nullable Snowflake before,
      @Nullable Integer limit,
      Guild guild) {
    this.userId = userId;
    this.actionType = actionType;
    this.before = before;
    this.limit = limit;
    this.guild = guild;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @Override
  public @Nullable Snowflake userId() {
    return userId;
  }

  /**
   * @return The value of the {@code actionType} attribute
   */
  @Override
  public @Nullable ActionType actionType() {
    return actionType;
  }

  /**
   * @return The value of the {@code before} attribute
   */
  @Override
  public @Nullable Snowflake before() {
    return before;
  }

  /**
   * @return The value of the {@code limit} attribute
   */
  @Override
  public @Nullable Integer limit() {
    return limit;
  }

  /**
   * @return The value of the {@code guild} attribute
   */
  @Override
  public Guild guild() {
    return guild;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuditLogQueryFlux#userId() userId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final AuditLogQueryFlux withUserId(@Nullable Snowflake value) {
    if (this.userId == value) return this;
    return new AuditLogQueryFlux(value, this.actionType, this.before, this.limit, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuditLogQueryFlux#actionType() actionType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for actionType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final AuditLogQueryFlux withActionType(@Nullable ActionType value) {
    if (this.actionType == value) return this;
    return new AuditLogQueryFlux(this.userId, value, this.before, this.limit, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuditLogQueryFlux#before() before} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for before (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final AuditLogQueryFlux withBefore(@Nullable Snowflake value) {
    if (this.before == value) return this;
    return new AuditLogQueryFlux(this.userId, this.actionType, value, this.limit, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuditLogQueryFlux#limit() limit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for limit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final AuditLogQueryFlux withLimit(@Nullable Integer value) {
    if (Objects.equals(this.limit, value)) return this;
    return new AuditLogQueryFlux(this.userId, this.actionType, this.before, value, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuditLogQueryFlux#guild() guild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for guild
   * @return A modified copy of the {@code this} object
   */
  public final AuditLogQueryFlux withGuild(Guild value) {
    if (this.guild == value) return this;
    Guild newValue = Objects.requireNonNull(value, "guild");
    return new AuditLogQueryFlux(this.userId, this.actionType, this.before, this.limit, newValue);
  }

  /**
   * This instance is equal to all instances of {@code AuditLogQueryFlux} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AuditLogQueryFlux
        && equalTo(0, (AuditLogQueryFlux) another);
  }

  private boolean equalTo(int synthetic, AuditLogQueryFlux another) {
    return Objects.equals(userId, another.userId)
        && Objects.equals(actionType, another.actionType)
        && Objects.equals(before, another.before)
        && Objects.equals(limit, another.limit)
        && guild.equals(another.guild);
  }

  /**
   * Computes a hash code from attributes: {@code userId}, {@code actionType}, {@code before}, {@code limit}, {@code guild}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(userId);
    h += (h << 5) + Objects.hashCode(actionType);
    h += (h << 5) + Objects.hashCode(before);
    h += (h << 5) + Objects.hashCode(limit);
    h += (h << 5) + guild.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AuditLogQueryFlux} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AuditLogQueryFlux{"
        + "userId=" + userId
        + ", actionType=" + actionType
        + ", before=" + before
        + ", limit=" + limit
        + ", guild=" + guild
        + "}";
  }

  /**
   * Construct a new immutable {@code AuditLogQueryFlux} instance.
   * @param guild The value for the {@code guild} attribute
   * @return An immutable AuditLogQueryFlux instance
   */
  public static AuditLogQueryFlux of(Guild guild) {
    return new AuditLogQueryFlux(guild);
  }

  /**
   * Creates an immutable copy of a {@link AuditLogQueryFluxGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AuditLogQueryFlux instance
   */
  static AuditLogQueryFlux copyOf(AuditLogQueryFluxGenerator instance) {
    if (instance instanceof AuditLogQueryFlux) {
      return (AuditLogQueryFlux) instance;
    }
    return AuditLogQueryFlux.of(instance.guild())
        .withUserId(instance.userId())
        .withActionType(instance.actionType())
        .withBefore(instance.before())
        .withLimit(instance.limit());
  }
}
