/*
 * This file is part of Discord4J.
 *
 * Discord4J is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Discord4J is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Discord4J.  If not, see <http://www.gnu.org/licenses/>.
 */
package discord4j.core.event.domain.integration;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.Event;
import discord4j.core.object.entity.Integration;
import discord4j.gateway.ShardInfo;

/**
 * Dispatched when an integration is updated.
 * This event is dispatched by Discord.
 *
 * @see
 * <a href="https://discord.com/developers/docs/topics/gateway#integration-update">Integration Update</a>
 */
public class IntegrationUpdateEvent extends Event {

    private final long guildId;
    private final Integration integration;

    public IntegrationUpdateEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long guildId,
                                  Integration integration) {
        super(gateway, shardInfo);
        this.guildId = guildId;
        this.integration = integration;
    }

    /**
     * Gets the id of the guild.
     *
     * @return The id of the guild.
     */
    public Snowflake getGuildId() {
        return Snowflake.of(guildId);
    }

    /**
     * Gets the updated integration.
     *
     * @return The updated integration.
     */
    public Integration getIntegration() {
        return integration;
    }

}
