/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.gateway.VoiceStateUpdate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="VoiceStateUpdate", generator="Immutables")
public final class ImmutableVoiceStateUpdate
implements VoiceStateUpdate {
    private final long guildId_value;
    private final long channelId_value;
    private final boolean channelId_present;
    private final boolean selfMute;
    private final boolean selfDeaf;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableVoiceStateUpdate(Id guildId, Optional<Id> channelId, boolean selfMute, boolean selfDeaf) {
        Id guildId$impl = guildId;
        Optional<Id> channelId$impl = channelId;
        this.selfMute = selfMute;
        this.selfDeaf = selfDeaf;
        this.guildId_value = guildId$impl.asLong();
        this.channelId_value = channelId$impl.map(Id::asLong).orElse(0L);
        this.channelId_present = channelId$impl.isPresent();
        this.initShim = null;
    }

    private ImmutableVoiceStateUpdate(ImmutableVoiceStateUpdate original, Id guildId, Optional<Id> channelId, boolean selfMute, boolean selfDeaf) {
        Id guildId$impl = guildId;
        Optional<Id> channelId$impl = channelId;
        this.selfMute = selfMute;
        this.selfDeaf = selfDeaf;
        this.guildId_value = guildId$impl.asLong();
        this.channelId_value = channelId$impl.map(Id::asLong).orElse(0L);
        this.channelId_present = channelId$impl.isPresent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of((long)this.guildId_value);
    }

    @Override
    @JsonProperty(value="channel_id")
    public Optional<Id> channelId() {
        return this.channelId_present ? Optional.of(Id.of((long)this.channelId_value)) : Optional.empty();
    }

    @Override
    @JsonProperty(value="self_mute")
    public boolean selfMute() {
        return this.selfMute;
    }

    @Override
    @JsonProperty(value="self_deaf")
    public boolean selfDeaf() {
        return this.selfDeaf;
    }

    public ImmutableVoiceStateUpdate withGuildId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableVoiceStateUpdate(this, newValue, this.channelId(), this.selfMute, this.selfDeaf);
    }

    public ImmutableVoiceStateUpdate withGuildId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableVoiceStateUpdate(this, newValue, this.channelId(), this.selfMute, this.selfDeaf);
    }

    public ImmutableVoiceStateUpdate withChannelId(Optional<Id> value) {
        Optional<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableVoiceStateUpdate(this, this.guildId(), newValue, this.selfMute, this.selfDeaf);
    }

    public ImmutableVoiceStateUpdate withChannelId(long value) {
        Optional<Id> newValue = Optional.of(Id.of((long)value));
        return new ImmutableVoiceStateUpdate(this, this.guildId(), newValue, this.selfMute, this.selfDeaf);
    }

    public final ImmutableVoiceStateUpdate withSelfMute(boolean value) {
        if (this.selfMute == value) {
            return this;
        }
        return new ImmutableVoiceStateUpdate(this, this.guildId(), this.channelId(), value, this.selfDeaf);
    }

    public final ImmutableVoiceStateUpdate withSelfDeaf(boolean value) {
        if (this.selfDeaf == value) {
            return this;
        }
        return new ImmutableVoiceStateUpdate(this, this.guildId(), this.channelId(), this.selfMute, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVoiceStateUpdate && this.equalTo(0, (ImmutableVoiceStateUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableVoiceStateUpdate another) {
        return Objects.equals(this.guildId_value, another.guildId_value) && this.channelId().equals(another.channelId()) && this.selfMute == another.selfMute && this.selfDeaf == another.selfDeaf;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.guildId_value);
        h += (h << 5) + this.channelId().hashCode();
        h += (h << 5) + Boolean.hashCode(this.selfMute);
        h += (h << 5) + Boolean.hashCode(this.selfDeaf);
        return h;
    }

    public String toString() {
        return "VoiceStateUpdate{guildId=" + Objects.toString(this.guildId_value) + ", channelId=" + this.channelId().toString() + ", selfMute=" + this.selfMute + ", selfDeaf=" + this.selfDeaf + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableVoiceStateUpdate fromJson(Json json) {
        Builder builder = ImmutableVoiceStateUpdate.builder();
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.selfMuteIsSet) {
            builder.selfMute(json.selfMute);
        }
        if (json.selfDeafIsSet) {
            builder.selfDeaf(json.selfDeaf);
        }
        return builder.build();
    }

    public static ImmutableVoiceStateUpdate of(Id guildId, Optional<Id> channelId, boolean selfMute, boolean selfDeaf) {
        return new ImmutableVoiceStateUpdate(guildId, channelId, selfMute, selfDeaf);
    }

    public static ImmutableVoiceStateUpdate copyOf(VoiceStateUpdate instance) {
        if (instance instanceof ImmutableVoiceStateUpdate) {
            return (ImmutableVoiceStateUpdate)instance;
        }
        return ImmutableVoiceStateUpdate.builder().from(instance).build();
    }

    public boolean isChannelIdPresent() {
        return this.channelId_present;
    }

    public long channelIdOrElse(long defaultValue) {
        return this.channelId_present ? this.channelId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="VoiceStateUpdate", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SELF_MUTE = 1L;
        private static final long INIT_BIT_SELF_DEAF = 2L;
        private long initBits = 3L;
        private Id guildId_id = null;
        private Optional<Id> channelId_optional = Optional.empty();
        private boolean selfMute;
        private boolean selfDeaf;

        private Builder() {
        }

        public final Builder from(VoiceStateUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.guildId(instance.guildId());
            this.channelId(instance.channelId());
            this.selfMute(instance.selfMute());
            this.selfDeaf(instance.selfDeaf());
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of((String)value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        public Builder channelId(String value) {
            this.channelId_optional = Optional.of(Id.of((String)value));
            return this;
        }

        public Builder channelId(long value) {
            this.channelId_optional = Optional.of(Id.of((long)value));
            return this;
        }

        @JsonProperty(value="channel_id")
        public Builder channelId(Optional<Id> value) {
            this.channelId_optional = value;
            return this;
        }

        @JsonProperty(value="self_mute")
        public final Builder selfMute(boolean selfMute) {
            this.selfMute = selfMute;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="self_deaf")
        public final Builder selfDeaf(boolean selfDeaf) {
            this.selfDeaf = selfDeaf;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableVoiceStateUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVoiceStateUpdate(null, this.guildId_build(), this.channelId_build(), this.selfMute, this.selfDeaf);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("selfMute");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("selfDeaf");
            }
            return "Cannot build VoiceStateUpdate, some of required attributes are not set " + attributes;
        }

        private Id guildId_build() {
            return this.guildId_id;
        }

        private Optional<Id> channelId_build() {
            return this.channelId_optional;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="VoiceStateUpdate", generator="Immutables")
    static final class Json
    implements VoiceStateUpdate {
        Id guildId;
        Optional<Id> channelId = Optional.empty();
        boolean selfMute;
        boolean selfMuteIsSet;
        boolean selfDeaf;
        boolean selfDeafIsSet;

        Json() {
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Optional<Id> channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="self_mute")
        public void setSelfMute(boolean selfMute) {
            this.selfMute = selfMute;
            this.selfMuteIsSet = true;
        }

        @JsonProperty(value="self_deaf")
        public void setSelfDeaf(boolean selfDeaf) {
            this.selfDeaf = selfDeaf;
            this.selfDeafIsSet = true;
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Id> channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean selfMute() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean selfDeaf() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="VoiceStateUpdate", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build VoiceStateUpdate, attribute initializers form cycle " + attributes;
        }
    }
}

