/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.StickerData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="StickerData", generator="Immutables")
public final class ImmutableStickerData
implements StickerData {
    private final long id_value;
    private final long packId_value;
    private final String name;
    private final String description;
    private final String tags_value;
    private final boolean tags_absent;
    private final String asset;
    private final int formatType;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableStickerData(Id id, Id packId, String name, String description, Possible<String> tags, String asset, int formatType) {
        Id id$impl = id;
        Id packId$impl = packId;
        this.name = Objects.requireNonNull(name, "name");
        this.description = Objects.requireNonNull(description, "description");
        Possible<String> tags$impl = tags;
        this.asset = Objects.requireNonNull(asset, "asset");
        this.formatType = formatType;
        this.id_value = id$impl.asLong();
        this.packId_value = packId$impl.asLong();
        this.tags_value = tags$impl.toOptional().orElse(null);
        this.tags_absent = tags$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableStickerData(ImmutableStickerData original, Id id, Id packId, String name, String description, Possible<String> tags, String asset, int formatType) {
        Id id$impl = id;
        Id packId$impl = packId;
        this.name = name;
        this.description = description;
        Possible<String> tags$impl = tags;
        this.asset = asset;
        this.formatType = formatType;
        this.id_value = id$impl.asLong();
        this.packId_value = packId$impl.asLong();
        this.tags_value = tags$impl.toOptional().orElse(null);
        this.tags_absent = tags$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of((long)this.id_value);
    }

    @Override
    @JsonProperty(value="pack_id")
    public Id packId() {
        return Id.of((long)this.packId_value);
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="tags")
    public Possible<String> tags() {
        return this.tags_absent ? Possible.absent() : Possible.of((Object)this.tags_value);
    }

    @Override
    @JsonProperty(value="asset")
    public String asset() {
        return this.asset;
    }

    @Override
    @JsonProperty(value="format_type")
    public int formatType() {
        return this.formatType;
    }

    public ImmutableStickerData withId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableStickerData(this, newValue, this.packId(), this.name, this.description, this.tags(), this.asset, this.formatType);
    }

    public ImmutableStickerData withId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableStickerData(this, newValue, this.packId(), this.name, this.description, this.tags(), this.asset, this.formatType);
    }

    public ImmutableStickerData withPackId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableStickerData(this, this.id(), newValue, this.name, this.description, this.tags(), this.asset, this.formatType);
    }

    public ImmutableStickerData withPackId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableStickerData(this, this.id(), newValue, this.name, this.description, this.tags(), this.asset, this.formatType);
    }

    public final ImmutableStickerData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableStickerData(this, this.id(), this.packId(), newValue, this.description, this.tags(), this.asset, this.formatType);
    }

    public final ImmutableStickerData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableStickerData(this, this.id(), this.packId(), this.name, newValue, this.tags(), this.asset, this.formatType);
    }

    public ImmutableStickerData withTags(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableStickerData(this, this.id(), this.packId(), this.name, this.description, newValue, this.asset, this.formatType);
    }

    public ImmutableStickerData withTags(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableStickerData(this, this.id(), this.packId(), this.name, this.description, (Possible<String>)newValue, this.asset, this.formatType);
    }

    public final ImmutableStickerData withAsset(String value) {
        String newValue = Objects.requireNonNull(value, "asset");
        if (this.asset.equals(newValue)) {
            return this;
        }
        return new ImmutableStickerData(this, this.id(), this.packId(), this.name, this.description, this.tags(), newValue, this.formatType);
    }

    public final ImmutableStickerData withFormatType(int value) {
        if (this.formatType == value) {
            return this;
        }
        return new ImmutableStickerData(this, this.id(), this.packId(), this.name, this.description, this.tags(), this.asset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStickerData && this.equalTo(0, (ImmutableStickerData)another);
    }

    private boolean equalTo(int synthetic, ImmutableStickerData another) {
        return Objects.equals(this.id_value, another.id_value) && Objects.equals(this.packId_value, another.packId_value) && this.name.equals(another.name) && this.description.equals(another.description) && this.tags().equals(another.tags()) && this.asset.equals(another.asset) && this.formatType == another.formatType;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id_value);
        h += (h << 5) + Objects.hashCode(this.packId_value);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.tags().hashCode();
        h += (h << 5) + this.asset.hashCode();
        h += (h << 5) + this.formatType;
        return h;
    }

    public String toString() {
        return "StickerData{id=" + Objects.toString(this.id_value) + ", packId=" + Objects.toString(this.packId_value) + ", name=" + this.name + ", description=" + this.description + ", tags=" + this.tags().toString() + ", asset=" + this.asset + ", formatType=" + this.formatType + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStickerData fromJson(Json json) {
        Builder builder = ImmutableStickerData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.packId != null) {
            builder.packId(json.packId);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.tags != null) {
            builder.tags(json.tags);
        }
        if (json.asset != null) {
            builder.asset(json.asset);
        }
        if (json.formatTypeIsSet) {
            builder.formatType(json.formatType);
        }
        return builder.build();
    }

    public static ImmutableStickerData of(Id id, Id packId, String name, String description, Possible<String> tags, String asset, int formatType) {
        return new ImmutableStickerData(id, packId, name, description, tags, asset, formatType);
    }

    public static ImmutableStickerData copyOf(StickerData instance) {
        if (instance instanceof ImmutableStickerData) {
            return (ImmutableStickerData)instance;
        }
        return ImmutableStickerData.builder().from(instance).build();
    }

    public boolean isTagsPresent() {
        return !this.tags_absent;
    }

    public String tagsOrElse(String defaultValue) {
        return !this.tags_absent ? this.tags_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StickerData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private static final long INIT_BIT_ASSET = 4L;
        private static final long INIT_BIT_FORMAT_TYPE = 8L;
        private long initBits = 15L;
        private Id id_id = null;
        private Id packId_id = null;
        private Possible<String> tags_possible = Possible.absent();
        private String name;
        private String description;
        private String asset;
        private int formatType;

        private Builder() {
        }

        public final Builder from(StickerData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.packId(instance.packId());
            this.name(instance.name());
            this.description(instance.description());
            this.tags(instance.tags());
            this.asset(instance.asset());
            this.formatType(instance.formatType());
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of((String)value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        public Builder packId(String value) {
            this.packId_id = Id.of((String)value);
            return this;
        }

        public Builder packId(long value) {
            this.packId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="pack_id")
        public Builder packId(Id value) {
            this.packId_id = value;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="tags")
        public Builder tags(Possible<String> value) {
            this.tags_possible = value;
            return this;
        }

        public Builder tags(String value) {
            this.tags_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="asset")
        public final Builder asset(String asset) {
            this.asset = Objects.requireNonNull(asset, "asset");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="format_type")
        public final Builder formatType(int formatType) {
            this.formatType = formatType;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableStickerData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStickerData(null, this.id_build(), this.packId_build(), this.name, this.description, this.tags_build(), this.asset, this.formatType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("asset");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("formatType");
            }
            return "Cannot build StickerData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Id packId_build() {
            return this.packId_id;
        }

        private Possible<String> tags_build() {
            return this.tags_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StickerData", generator="Immutables")
    static final class Json
    implements StickerData {
        Id id;
        Id packId;
        String name;
        String description;
        Possible<String> tags = Possible.absent();
        String asset;
        int formatType;
        boolean formatTypeIsSet;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="pack_id")
        public void setPackId(Id packId) {
            this.packId = packId;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="tags")
        public void setTags(Possible<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="asset")
        public void setAsset(String asset) {
            this.asset = asset;
        }

        @JsonProperty(value="format_type")
        public void setFormatType(int formatType) {
            this.formatType = formatType;
            this.formatTypeIsSet = true;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id packId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String asset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int formatType() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="StickerData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build StickerData, attribute initializers form cycle " + attributes;
        }
    }
}

