/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.Request;
import io.github.bucket4j.distributed.serialization.InternalSerializationHelper;
import io.github.bucket4j.distributed.versioning.UnsupportedTypeException;
import io.github.bucket4j.distributed.versioning.UsageOfObsoleteApiException;
import io.github.bucket4j.distributed.versioning.UsageOfUnsupportedApiException;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;

public abstract class AbstractBinaryTransaction {
    private final byte[] requestBytes;
    private Version backwardCompatibilityVersion;

    protected AbstractBinaryTransaction(byte[] requestBytes) {
        this.requestBytes = requestBytes;
    }

    public byte[] execute() {
        Request request;
        try {
            request = InternalSerializationHelper.deserializeRequest(this.requestBytes);
        }
        catch (UnsupportedTypeException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.unsupportedType(e.getTypeId()), Versions.getOldest());
        }
        catch (UsageOfUnsupportedApiException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.usageOfUnsupportedApiException(e.getRequestedFormatNumber(), e.getMaxSupportedFormatNumber()), Versions.getOldest());
        }
        catch (UsageOfObsoleteApiException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.usageOfObsoleteApiException(e.getRequestedFormatNumber(), e.getMinSupportedFormatNumber()), Versions.getOldest());
        }
        this.backwardCompatibilityVersion = request.getBackwardCompatibilityVersion();
        try {
            RemoteBucketState currentState = null;
            if (this.exists()) {
                byte[] stateBytes = this.getRawState();
                currentState = InternalSerializationHelper.deserializeState(stateBytes);
            }
            MutableBucketEntry entryWrapper = new MutableBucketEntry(currentState);
            long time = request.getClientSideTime() != null ? request.getClientSideTime() : System.currentTimeMillis() * 1000000L;
            RemoteCommand command = request.getCommand();
            CommandResult result = command.execute(entryWrapper, time);
            if (entryWrapper.isStateModified()) {
                RemoteBucketState newState = entryWrapper.get();
                this.setRawState(InternalSerializationHelper.serializeState(newState, this.backwardCompatibilityVersion));
            }
            return InternalSerializationHelper.serializeResult(result, request.getBackwardCompatibilityVersion());
        }
        catch (UnsupportedTypeException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.unsupportedType(e.getTypeId()), this.backwardCompatibilityVersion);
        }
        catch (UsageOfUnsupportedApiException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.usageOfUnsupportedApiException(e.getRequestedFormatNumber(), e.getMaxSupportedFormatNumber()), this.backwardCompatibilityVersion);
        }
        catch (UsageOfObsoleteApiException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.usageOfObsoleteApiException(e.getRequestedFormatNumber(), e.getMinSupportedFormatNumber()), this.backwardCompatibilityVersion);
        }
    }

    protected abstract byte[] getRawState();

    protected abstract void setRawState(byte[] var1);

    public abstract boolean exists();
}

