/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.generic.compare_and_swap;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AsyncCompareAndSwapOperation;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.CompareAndSwapOperation;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.Request;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractCompareAndSwapBasedProxyManager<K>
extends AbstractProxyManager<K> {
    private static final CommandResult<?> UNSUCCESSFUL_CAS_RESULT = null;

    protected AbstractCompareAndSwapBasedProxyManager(ClientSideConfig clientSideConfig) {
        super(AbstractCompareAndSwapBasedProxyManager.injectTimeClock(clientSideConfig));
    }

    @Override
    public <T> CommandResult<T> execute(K key, Request<T> request) {
        CommandResult<T> result;
        CompareAndSwapOperation operation = this.beginCompareAndSwapOperation(key);
        while ((result = this.execute(request, operation)) == UNSUCCESSFUL_CAS_RESULT) {
        }
        return result;
    }

    @Override
    public <T> CompletableFuture<CommandResult<T>> executeAsync(K key, Request<T> request) {
        AsyncCompareAndSwapOperation operation = this.beginAsyncCompareAndSwapOperation(key);
        CompletableFuture<CommandResult<T>> result = this.executeAsync(request, operation);
        return result.thenCompose(response -> this.retryIfCasWasUnsuccessful(operation, request, (CommandResult)response));
    }

    protected abstract CompareAndSwapOperation beginCompareAndSwapOperation(K var1);

    protected abstract AsyncCompareAndSwapOperation beginAsyncCompareAndSwapOperation(K var1);

    private <T> CommandResult<T> execute(Request<T> request, CompareAndSwapOperation operation) {
        RemoteCommand<T> command = request.getCommand();
        byte[] originalStateBytes = operation.getStateData().orElse(null);
        MutableBucketEntry entry = new MutableBucketEntry(originalStateBytes);
        CommandResult<T> result = command.execute(entry, this.getClientSideTime());
        if (!entry.isStateModified()) {
            return result;
        }
        byte[] newStateBytes = entry.getStateBytes(request.getBackwardCompatibilityVersion());
        if (operation.compareAndSwap(originalStateBytes, newStateBytes, entry.get())) {
            return result;
        }
        return null;
    }

    private <T> CompletableFuture<CommandResult<T>> retryIfCasWasUnsuccessful(AsyncCompareAndSwapOperation operation, Request<T> request, CommandResult<T> casResponse) {
        if (casResponse != UNSUCCESSFUL_CAS_RESULT) {
            return CompletableFuture.completedFuture(casResponse);
        }
        return this.executeAsync(request, operation).thenCompose(response -> this.retryIfCasWasUnsuccessful(operation, request, (CommandResult)response));
    }

    private <T> CompletableFuture<CommandResult<T>> executeAsync(Request<T> request, AsyncCompareAndSwapOperation operation) {
        return ((CompletableFuture)operation.getStateData().thenApply(originalStateBytes -> originalStateBytes.orElse(null))).thenCompose(originalStateBytes -> {
            RemoteCommand command = request.getCommand();
            MutableBucketEntry entry = new MutableBucketEntry((byte[])originalStateBytes);
            CommandResult result = command.execute(entry, this.getClientSideTime());
            if (!entry.isStateModified()) {
                return CompletableFuture.completedFuture(result);
            }
            byte[] newStateBytes = entry.getStateBytes(request.getBackwardCompatibilityVersion());
            return operation.compareAndSwap((byte[])originalStateBytes, newStateBytes, entry.get()).thenApply(casWasSuccessful -> casWasSuccessful != false ? result : null);
        });
    }

    private static ClientSideConfig injectTimeClock(ClientSideConfig clientSideConfig) {
        if (clientSideConfig.getClientSideClock().isPresent()) {
            return clientSideConfig;
        }
        return clientSideConfig.withClientClock(TimeMeter.SYSTEM_MILLISECONDS);
    }
}

