/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Request<T>
implements ComparableByContent<Request<T>> {
    private final Version backwardCompatibilityVersion;
    private final RemoteCommand<T> command;
    private final Long clientSideTime;
    private final ExpirationAfterWriteStrategy expirationStrategy;
    public static SerializationHandle<Request<?>> SERIALIZATION_HANDLE = new SerializationHandle<Request<?>>(){

        @Override
        public <S> Request<?> deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            boolean hasExpireStrategy;
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_8_10_0);
            int backwardCompatibilityNumber = adapter.readInt(input);
            Version requestBackwardCompatibilityVersion = Versions.byNumber(backwardCompatibilityNumber);
            RemoteCommand<?> command = RemoteCommand.deserialize(adapter, input);
            Long clientTime = null;
            boolean clientTimeProvided = adapter.readBoolean(input);
            if (clientTimeProvided) {
                clientTime = adapter.readLong(input);
            }
            ExpirationAfterWriteStrategy expireStrategy = null;
            if (formatNumber >= Versions.v_8_10_0.getNumber() && (hasExpireStrategy = adapter.readBoolean(input))) {
                expireStrategy = ExpirationAfterWriteStrategy.deserialize(adapter, input);
            }
            return new Request(command, requestBackwardCompatibilityVersion, clientTime, expireStrategy);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, Request<?> request, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            Version selfVersion = ((Request)request).getSelfVersion();
            Version effectiveVersion = Versions.max(((Request)request).command.getRequiredVersion(), selfVersion);
            Versions.check(effectiveVersion.getNumber(), Versions.v_7_0_0, ((Request)request).backwardCompatibilityVersion);
            adapter.writeInt(output, selfVersion.getNumber());
            adapter.writeInt(output, effectiveVersion.getNumber());
            RemoteCommand.serialize(adapter, output, ((Request)request).command, backwardCompatibilityVersion, scope);
            if (((Request)request).clientSideTime != null) {
                adapter.writeBoolean(output, true);
                adapter.writeLong(output, ((Request)request).clientSideTime);
            } else {
                adapter.writeBoolean(output, false);
            }
            if (selfVersion.getNumber() >= Versions.v_8_10_0.getNumber()) {
                if (((Request)request).expirationStrategy != null) {
                    adapter.writeBoolean(output, true);
                    ExpirationAfterWriteStrategy.serialize(adapter, output, ((Request)request).expirationStrategy, backwardCompatibilityVersion, scope);
                } else {
                    adapter.writeBoolean(output, false);
                }
            }
        }

        @Override
        public int getTypeId() {
            return 37;
        }

        @Override
        public Class<Request<?>> getSerializedType() {
            return Request.class;
        }

        @Override
        public Request<?> fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_8_10_0);
            int backwardCompatibilityNumber = this.readIntValue(snapshot, "backwardCompatibilityNumber");
            Version requestBackwardCompatibilityVersion = Versions.byNumber(backwardCompatibilityNumber);
            RemoteCommand<?> command = RemoteCommand.fromJsonCompatibleSnapshot((Map)snapshot.get("command"));
            Long clientTime = null;
            if (snapshot.containsKey("clientTime")) {
                clientTime = this.readLongValue(snapshot, "clientTime");
            }
            ExpirationAfterWriteStrategy expireStrategy = null;
            if (snapshot.containsKey("expireAfterWriteStrategy")) {
                expireStrategy = ExpirationAfterWriteStrategy.fromJsonCompatibleSnapshot((Map)snapshot.get("expireAfterWriteStrategy"));
            }
            return new Request(command, requestBackwardCompatibilityVersion, clientTime, expireStrategy);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(Request<?> request, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            Version effectiveVersion = Versions.max(((Request)request).command.getRequiredVersion(), ((Request)request).getSelfVersion());
            Versions.check(effectiveVersion.getNumber(), Versions.v_7_0_0, ((Request)request).backwardCompatibilityVersion);
            Version selfVersion = ((Request)request).getSelfVersion();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", selfVersion.getNumber());
            result.put("backwardCompatibilityNumber", effectiveVersion.getNumber());
            result.put("command", RemoteCommand.toJsonCompatibleSnapshot(((Request)request).command, backwardCompatibilityVersion, scope));
            if (((Request)request).clientSideTime != null) {
                result.put("clientTime", ((Request)request).clientSideTime);
            }
            if (((Request)request).expirationStrategy != null) {
                result.put("expireAfterWriteStrategy", ExpirationAfterWriteStrategy.toJsonCompatibleSnapshot(((Request)request).expirationStrategy, backwardCompatibilityVersion, scope));
            }
            return result;
        }

        @Override
        public String getTypeName() {
            return "Request";
        }
    };

    public Request(RemoteCommand<T> command, Version backwardCompatibilityVersion, Long clientSideTime, ExpirationAfterWriteStrategy expirationStrategy) {
        this.command = command;
        this.clientSideTime = clientSideTime;
        this.backwardCompatibilityVersion = backwardCompatibilityVersion;
        this.expirationStrategy = expirationStrategy;
    }

    public RemoteCommand<T> getCommand() {
        return this.command;
    }

    public Version getBackwardCompatibilityVersion() {
        return this.backwardCompatibilityVersion;
    }

    public Long getClientSideTime() {
        return this.clientSideTime;
    }

    public ExpirationAfterWriteStrategy getExpirationStrategy() {
        return this.expirationStrategy;
    }

    private Version getSelfVersion() {
        return this.expirationStrategy != null ? Versions.v_8_10_0 : Versions.v_7_0_0;
    }

    @Override
    public boolean equalsByContent(Request<T> other) {
        return ComparableByContent.equals(this.command, other.command) && Objects.equals(this.clientSideTime, other.clientSideTime);
    }
}

