/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.feature.sts;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.exception.KittehStsException;
import org.kitteh.irc.client.library.feature.sts.StsPolicy;
import org.kitteh.irc.client.library.feature.sts.StsStorageManager;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.StsUtil;

public class StsPropertiesStorageManager
implements StsStorageManager {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private final Properties properties = new Properties();
    private final Path filePath;

    public StsPropertiesStorageManager(@NonNull Path filePath) {
        this.filePath = Sanity.nullCheck(filePath, "Must provide a valid path to the properties file to use.");
        this.readData();
    }

    private void readData() {
        if (!Files.exists(this.filePath, new LinkOption[0])) {
            return;
        }
        try (BufferedReader bufferedReader = Files.newBufferedReader(this.filePath, StandardCharsets.UTF_8);){
            this.properties.load(bufferedReader);
        }
        catch (IOException e) {
            throw new KittehStsException(e.getMessage(), e);
        }
    }

    @Override
    public void addEntry(@NonNull String hostname, long duration, @NonNull StsPolicy policy) {
        Sanity.nullCheck(hostname, "A valid hostname must be provided for this entry.");
        Sanity.nullCheck(policy, "A valid policy must be provided to be inserted.");
        if (!policy.getOptions().containsKey("duration")) {
            policy.getOptions().put("duration", String.valueOf(duration));
        }
        this.properties.setProperty(hostname, this.getExpiryFromDuration(duration) + "; " + this.reserializeData(policy));
        this.saveData();
    }

    private void saveData() {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.filePath, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            this.properties.store(bufferedWriter, "This file contains all the gathered STS policies.");
        }
        catch (IOException e) {
            throw new KittehStsException(e.getMessage());
        }
    }

    @Override
    public @NonNull Optional<StsPolicy> getEntry(@NonNull String hostname) {
        Sanity.nullCheck(hostname, "A valid hostname must be provided for this entry.");
        this.pruneEntries();
        if (!this.hasEntry(hostname)) {
            return Optional.empty();
        }
        String value = this.properties.getProperty(hostname);
        String[] components = value.split("; ");
        String data = components[1];
        return Optional.of(StsUtil.getStsPolicyFromString(",", data));
    }

    @Override
    public boolean hasEntry(@NonNull String hostname) {
        Sanity.nullCheck(hostname, "A valid hostname must be provided for this entry.");
        this.pruneEntries();
        return this.properties.containsKey(hostname);
    }

    private void pruneEntries() {
        HashSet<String> stagedRemovals = new HashSet<String>();
        for (String hostname : this.properties.stringPropertyNames()) {
            String value = this.properties.getProperty(hostname);
            String[] components = value.split("; ");
            ZonedDateTime dt = ZonedDateTime.parse(components[0], DATE_TIME_FORMATTER);
            if (!dt.isBefore(ZonedDateTime.now(ZoneOffset.UTC))) continue;
            stagedRemovals.add(hostname);
        }
        this.properties.keySet().removeAll(stagedRemovals);
        this.saveData();
    }

    @Override
    public void removeEntry(@NonNull String hostname) {
        Sanity.nullCheck(hostname, "A valid hostname must be provided for this entry.");
        this.pruneEntries();
        this.properties.remove(hostname);
    }

    private String reserializeData(StsPolicy policy) {
        StringBuilder sb = new StringBuilder(policy.getOptions().size() * 10 + policy.getFlags().size() * 5);
        sb.append(String.join((CharSequence)",", policy.getFlags()));
        if (!policy.getFlags().isEmpty()) {
            sb.append(',');
        }
        sb.append(policy.getOptions().entrySet().stream().map(e -> (String)e.getKey() + '=' + (String)e.getValue()).collect(Collectors.joining(",")));
        return sb.toString();
    }

    private String getExpiryFromDuration(long duration) {
        return ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(duration).format(DATE_TIME_FORMATTER);
    }
}

