/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.feature.auth;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.feature.auth.AbstractAuthProtocol;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.StringUtil;
import org.kitteh.irc.client.library.util.ToStringer;

public abstract class AbstractAccountPassProtocol
extends AbstractAuthProtocol {
    private final String accountName;
    private final String password;

    protected AbstractAccountPassProtocol(@NonNull Client client, @Nullable String accountName, @NonNull String password) {
        super(client);
        this.accountName = accountName;
        this.password = Sanity.safeMessageCheck(password, "Password");
    }

    protected @Nullable String getAccountName() {
        return this.accountName;
    }

    protected @NonNull String getPassword() {
        return this.password;
    }

    @Override
    protected void toString(ToStringer stringer) {
        stringer.add("account", this.getAccountName());
        stringer.add("password", StringUtil.filterPassword(this.password));
    }
}

