/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.event.channel;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.Actor;
import org.kitteh.irc.client.library.element.Channel;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.element.User;
import org.kitteh.irc.client.library.event.abstractbase.ActorChannelMessageEventBase;
import org.kitteh.irc.client.library.event.helper.ChannelUserListChangeEvent;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class ChannelKickEvent
extends ActorChannelMessageEventBase<Actor>
implements ChannelUserListChangeEvent {
    private final User target;

    public ChannelKickEvent(@NonNull Client client, @NonNull ServerMessage sourceMessage, @NonNull Channel channel, @NonNull Actor actor, @NonNull User target, @NonNull String message) {
        super(client, sourceMessage, actor, channel, message);
        this.target = Sanity.nullCheck(target, "Target");
    }

    @Override
    public @NonNull Optional<Channel> getAffectedChannel() {
        return Optional.of(this.getChannel());
    }

    @Override
    public @NonNull ChannelUserListChangeEvent.Change getChange() {
        return ChannelUserListChangeEvent.Change.LEAVE;
    }

    public @NonNull User getTarget() {
        return this.target;
    }

    @Override
    public @NonNull User getUser() {
        return this.getTarget();
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("target", this.target);
    }
}

