/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.event.capabilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.CapabilityState;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.event.abstractbase.ServerMultipleMessageEventBase;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class CapabilitiesListEvent
extends ServerMultipleMessageEventBase {
    private final List<CapabilityState> capabilities;

    public CapabilitiesListEvent(@NonNull Client client, @NonNull List<ServerMessage> sourceMessages, @NonNull List<CapabilityState> capabilities) {
        super(client, sourceMessages);
        Sanity.nullCheck(capabilities, "Capabilities list");
        this.capabilities = Collections.unmodifiableList(new ArrayList<CapabilityState>(capabilities));
    }

    public @NonNull List<CapabilityState> getCapabilities() {
        return this.capabilities;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("capabilities", this.capabilities);
    }
}

