/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.event.abstractbase;

import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.element.User;
import org.kitteh.irc.client.library.event.abstractbase.ActorEventBase;
import org.kitteh.irc.client.library.event.helper.UserInfoChangeEvent;
import org.kitteh.irc.client.library.util.Change;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class UserInfoChangeEventBase<Type>
extends ActorEventBase<User>
implements UserInfoChangeEvent<Type> {
    private final User newUser;
    private final Change<Type> change;

    protected UserInfoChangeEventBase(@NonNull Client client, @NonNull ServerMessage sourceMessage, @NonNull User oldUser, @NonNull User newUser, @NonNull Function<User, Type> changedInfoGetter) {
        super(client, sourceMessage, oldUser);
        this.newUser = Sanity.nullCheck(newUser, "New user");
        this.change = new Change<Type>(changedInfoGetter.apply(oldUser), changedInfoGetter.apply(newUser));
    }

    @Override
    public @NonNull User getOldUser() {
        return (User)this.getActor();
    }

    @Override
    public @NonNull User getNewUser() {
        return this.newUser;
    }

    @Override
    public @NonNull Change<Type> getChange() {
        return this.change;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("newUser", this.newUser).add("change", this.change);
    }
}

