/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.event.abstractbase;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.Actor;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.event.abstractbase.ActorEventBase;
import org.kitteh.irc.client.library.event.helper.PrivateEvent;
import org.kitteh.irc.client.library.util.ToStringer;

public class PrivateEventBase<A extends Actor>
extends ActorEventBase<A>
implements PrivateEvent {
    private final boolean isToClient;
    private final String target;

    public PrivateEventBase(@NonNull Client client, @NonNull ServerMessage sourceMessage, @NonNull A sender, @NonNull String target) {
        super(client, sourceMessage, sender);
        this.target = target;
        this.isToClient = client.getServerInfo().getCaseMapping().areEqualIgnoringCase(client.getNick(), target);
    }

    @Override
    public @NonNull String getTarget() {
        return this.target;
    }

    @Override
    public boolean isToClient() {
        return this.isToClient;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("isToClient", this.isToClient).add("target", this.target);
    }
}

