/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.event.abstractbase;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.Channel;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.event.abstractbase.ServerMessageEventBase;
import org.kitteh.irc.client.library.event.helper.ChannelEvent;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public abstract class ChannelEventBase
extends ServerMessageEventBase
implements ChannelEvent {
    private final Channel channel;

    protected ChannelEventBase(@NonNull Client client, @NonNull ServerMessage sourceMessage, @NonNull Channel channel) {
        super(client, sourceMessage);
        Sanity.nullCheck(channel, "Channel");
        Sanity.truthiness(channel.getClient() == client, "Channel must be from given Client");
        this.channel = channel;
    }

    @Override
    public final @NonNull Channel getChannel() {
        return this.channel;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("channel", this.channel);
    }
}

