/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.listener;

import java.util.Map;
import java.util.Optional;
import net.engio.mbassy.listener.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import org.kitteh.irc.client.library.element.Actor;
import org.kitteh.irc.client.library.element.Channel;
import org.kitteh.irc.client.library.event.channel.ChannelTopicEvent;
import org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import org.kitteh.irc.client.library.feature.filter.CommandFilter;
import org.kitteh.irc.client.library.feature.filter.NumericFilter;
import org.kitteh.irc.client.library.util.CIKeyMap;

public class DefaultTopicListener
extends AbstractDefaultListenerBase {
    private final Map<String, Channel.Topic> oldTopics;

    public DefaultTopicListener(@NonNull Client.WithManagement client) {
        super(client);
        this.oldTopics = new CIKeyMap<Channel.Topic>(client);
    }

    @NumericFilter(value=332)
    @Handler(priority=0x7FFFFFFE)
    public void topic(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "Topic message too short");
            return;
        }
        Optional<Channel> topicChannel = this.getTracker().getChannel(event.getParameters().get(1));
        if (topicChannel.isPresent()) {
            Channel oldChannel = topicChannel.get();
            this.oldTopics.put(oldChannel.getName(), oldChannel.getTopic());
            this.getTracker().setChannelTopic(oldChannel.getName(), event.getParameters().get(2));
        } else {
            this.trackException(event, "Topic message sent for invalid channel name");
        }
    }

    @NumericFilter(value=333)
    @Handler(priority=0x7FFFFFFE)
    public void topicInfo(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 4) {
            this.trackException(event, "Topic message too short");
            return;
        }
        Optional<Channel> topicSetChannel = this.getTracker().getChannel(event.getParameters().get(1));
        if (topicSetChannel.isPresent()) {
            Channel oldChannel = topicSetChannel.get();
            this.getTracker().setChannelTopicInfo(oldChannel.getName(), Long.parseLong(event.getParameters().get(3)) * 1000L, this.getTracker().getActor(event.getParameters().get(2)));
            this.fire(new ChannelTopicEvent(this.getClient(), event.getSource(), oldChannel, this.oldTopics.remove(oldChannel.getName()), oldChannel.getLatest().get().getTopic(), false));
        } else {
            this.trackException(event, "Topic message sent for invalid channel name");
        }
    }

    @CommandFilter(value="TOPIC")
    @Handler(priority=0x7FFFFFFE)
    public void topic(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "TOPIC message too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getChannel(event.getParameters().get(0));
        if (channel.isPresent()) {
            Channel oldChannel = channel.get();
            this.getTracker().setChannelTopic(oldChannel.getName(), event.getParameters().get(1));
            this.getTracker().setChannelTopicInfo(oldChannel.getName(), System.currentTimeMillis(), (Actor)event.getActor());
            this.fire(new ChannelTopicEvent(this.getClient(), event.getSource(), oldChannel, oldChannel.getTopic(), oldChannel.getLatest().get().getTopic(), true));
        } else {
            this.trackException(event, "TOPIC message sent for invalid channel name");
        }
    }
}

