/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.listener;

import net.engio.mbassy.listener.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import org.kitteh.irc.client.library.element.Actor;
import org.kitteh.irc.client.library.event.channel.ChannelTagMessageEvent;
import org.kitteh.irc.client.library.event.channel.ChannelTargetedTagMessageEvent;
import org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import org.kitteh.irc.client.library.event.user.PrivateTagMessageEvent;
import org.kitteh.irc.client.library.feature.filter.CommandFilter;

public class DefaultTagmsgListener
extends AbstractDefaultListenerBase {
    public DefaultTagmsgListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @CommandFilter(value="TAGMSG")
    @Handler(priority=0x7FFFFFFE)
    public void tagmsg(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 1) {
            this.trackException(event, "TAGMSG message too short");
            return;
        }
        AbstractDefaultListenerBase.MessageTargetInfo messageTargetInfo = this.getTypeByTarget(event.getParameters().get(0));
        if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.Private) {
            this.fire(new PrivateTagMessageEvent((Client)this.getClient(), event.getSource(), (Actor)event.getActor(), event.getParameters().get(0)));
        } else if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo) {
            AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo channelInfo = (AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo)messageTargetInfo;
            this.fire(new ChannelTagMessageEvent((Client)this.getClient(), event.getSource(), (Actor)event.getActor(), channelInfo.getChannel()));
        } else if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.TargetedChannel) {
            AbstractDefaultListenerBase.MessageTargetInfo.TargetedChannel channelInfo = (AbstractDefaultListenerBase.MessageTargetInfo.TargetedChannel)messageTargetInfo;
            this.fire(new ChannelTargetedTagMessageEvent(this.getClient(), event.getSource(), (Actor)event.getActor(), channelInfo.getChannel(), channelInfo.getPrefix()));
        }
    }
}

