/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.listener;

import java.util.ArrayList;
import net.engio.mbassy.listener.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import org.kitteh.irc.client.library.event.client.FailEvent;
import org.kitteh.irc.client.library.event.client.NoteEvent;
import org.kitteh.irc.client.library.event.client.StandardReplyEvent;
import org.kitteh.irc.client.library.event.client.WarnEvent;
import org.kitteh.irc.client.library.feature.filter.CommandFilter;

public class DefaultStandardReplyListener
extends AbstractDefaultListenerBase {
    public DefaultStandardReplyListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @CommandFilter.Commands(value={@CommandFilter(value="FAIL"), @CommandFilter(value="NOTE"), @CommandFilter(value="WARN")})
    @Handler(priority=0x7FFFFFFE)
    public void invite(ClientReceiveCommandEvent event) {
        StandardReplyEvent.Type type = StandardReplyEvent.Type.valueOf(event.getCommand().toUpperCase());
        if (event.getParameters().size() < 3) {
            this.trackException(event, (Object)((Object)type) + " message too short");
            return;
        }
        String command = event.getParameters().get(0);
        String code = event.getParameters().get(1);
        ArrayList<String> context = new ArrayList<String>();
        int i = 2;
        while (i + 1 < event.getParameters().size()) {
            context.add(event.getParameters().get(i++));
        }
        String description = event.getParameters().get(i);
        switch (type) {
            case FAIL: {
                this.fire(new FailEvent(this.getClient(), event.getSource(), command, code, context, description));
                break;
            }
            case NOTE: {
                this.fire(new NoteEvent(this.getClient(), event.getSource(), command, code, context, description));
                break;
            }
            case WARN: {
                this.fire(new WarnEvent(this.getClient(), event.getSource(), command, code, context, description));
            }
        }
    }
}

