/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.element.isupport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportParameterValueRequired;
import org.kitteh.irc.client.library.defaults.element.mode.DefaultChannelUserMode;
import org.kitteh.irc.client.library.element.ISupportParameter;
import org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import org.kitteh.irc.client.library.exception.KittehServerISupportException;

public class DefaultISupportPrefix
extends DefaultISupportParameterValueRequired
implements ISupportParameter.Prefix {
    private static final Pattern PATTERN = Pattern.compile("\\(([a-zA-Z]+)\\)([^ ]+)");
    private final List<ChannelUserMode> modes;

    public DefaultISupportPrefix(@NonNull Client client, @NonNull String name, @Nullable String value) {
        super(client, name, value);
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.find()) {
            throw new KittehServerISupportException(name, "Data does not match expected pattern");
        }
        String modes = matcher.group(1);
        String display = matcher.group(2);
        if (modes.length() != display.length()) {
            throw new KittehServerISupportException(name, "Prefix and mode size mismatch");
        }
        ArrayList<DefaultChannelUserMode> prefixList = new ArrayList<DefaultChannelUserMode>();
        for (int index = 0; index < modes.length(); ++index) {
            prefixList.add(new DefaultChannelUserMode(client, modes.charAt(index), display.charAt(index)));
        }
        this.modes = Collections.unmodifiableList(prefixList);
    }

    @Override
    public @NonNull List<ChannelUserMode> getModes() {
        return this.modes;
    }
}

