/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.element;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.WhoisData;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class DefaultWhoisData
implements WhoisData {
    private final Client client;
    private final String account;
    private final Set<String> channels;
    private final String name;
    private final String nick;
    private final String userString;
    private final String host;
    private final long creationTime;
    private final String realName;
    private final String server;
    private final Long idleTime;
    private final String serverDescription;
    private final boolean secureConnection;
    private final String operatorInformation;
    private final Long signOnTime;
    private final boolean away;
    private final String awayMessage;

    public DefaultWhoisData(@NonNull Client client, @Nullable String account, @NonNull Set<String> channels, @NonNull String nick, @NonNull String userString, @NonNull String host, @Nullable String realName, @Nullable String server, @Nullable String serverDescription, boolean secureConnection, @Nullable String operatorInformation, @Nullable Long idleTime, @Nullable Long signOnTime, @Nullable String awayMessage) {
        this.client = client;
        this.account = account;
        this.channels = Collections.unmodifiableSet(new HashSet<String>(channels));
        this.name = nick + '!' + userString + '@' + host;
        this.nick = nick;
        this.userString = userString;
        this.host = host;
        this.realName = realName;
        this.server = server;
        this.serverDescription = serverDescription;
        this.operatorInformation = operatorInformation;
        this.secureConnection = secureConnection;
        this.idleTime = idleTime;
        this.signOnTime = signOnTime;
        this.away = awayMessage != null;
        this.awayMessage = awayMessage;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public @NonNull Optional<String> getAccount() {
        return Optional.ofNullable(this.account);
    }

    @Override
    public @NonNull Optional<String> getAwayMessage() {
        return Optional.ofNullable(this.awayMessage);
    }

    @Override
    public @NonNull Set<String> getChannels() {
        return this.channels;
    }

    @Override
    public @NonNull String getHost() {
        return this.host;
    }

    @Override
    public @NonNull String getNick() {
        return this.nick;
    }

    @Override
    public @NonNull Optional<String> getRealName() {
        return Optional.ofNullable(this.realName);
    }

    @Override
    public @NonNull Optional<String> getServer() {
        return Optional.ofNullable(this.server);
    }

    @Override
    public @NonNull String getUserString() {
        return this.userString;
    }

    @Override
    public boolean isAway() {
        return this.away;
    }

    @Override
    public @NonNull String getMessagingName() {
        return this.nick;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull Client getClient() {
        return this.client;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public @NonNull Optional<Long> getIdleTime() {
        return Optional.ofNullable(this.idleTime);
    }

    @Override
    public @NonNull Optional<String> getOperatorInformation() {
        return Optional.ofNullable(this.operatorInformation);
    }

    @Override
    public @NonNull Optional<String> getServerDescription() {
        return Optional.ofNullable(this.serverDescription);
    }

    @Override
    public @NonNull Optional<Long> getSignOnTime() {
        return Optional.ofNullable(this.signOnTime);
    }

    @Override
    public boolean isSecureConnection() {
        return this.secureConnection;
    }

    public @NonNull String toString() {
        return new ToStringer(this).add("client", this.client).add("account", this.account).add("channels", this.channels).add("name", this.name).add("creationTime", this.creationTime).add("realName", this.realName).add("server", this.server).add("serverDescription", this.serverDescription).add("secureConnection", this.secureConnection).add("operatorInformation", this.operatorInformation).add("idleTime", this.idleTime).add("signOnTime", this.signOnTime).add("awayMessage", this.awayMessage).toString();
    }

    public static class Builder {
        private final Client client;
        private String account;
        private final Set<String> channels = new HashSet<String>();
        private final String nick;
        private String userString;
        private String host;
        private String realName;
        private String server;
        private String serverDescription;
        private boolean secure;
        private String operatorInformation;
        private Long idleTime;
        private Long signOnTime;
        private String awayMessage;

        public Builder(@NonNull Client client, @NonNull String nick) {
            this.client = client;
            this.nick = nick;
        }

        public @NonNull String getNick() {
            return this.nick;
        }

        public void setAccount(@NonNull String account) {
            this.account = account;
        }

        public void addChannels(@NonNull String channels) {
            Collections.addAll(this.channels, Sanity.nullCheck(channels, "Channels").split(" "));
        }

        public void setAway(@NonNull String awayMessage) {
            this.awayMessage = awayMessage;
        }

        public void setUserString(@NonNull String userString) {
            this.userString = userString;
        }

        public void setHost(@NonNull String host) {
            this.host = host;
        }

        public void setRealName(@NonNull String realName) {
            this.realName = realName;
        }

        public void setServer(@NonNull String server) {
            this.server = server;
        }

        public void setServerDescription(@NonNull String serverDescription) {
            this.serverDescription = serverDescription;
        }

        public void setSecure() {
            this.secure = true;
        }

        public void setOperatorInformation(@NonNull String operatorInformation) {
            this.operatorInformation = operatorInformation;
        }

        public void setIdleTime(long idleTime) {
            this.idleTime = idleTime;
        }

        public void setSignOnTime(long signOnTime) {
            this.signOnTime = signOnTime;
        }

        public @NonNull WhoisData build() {
            return new DefaultWhoisData(this.client, this.account, this.channels, this.nick, this.userString, this.host, this.realName, this.server, this.serverDescription, this.secure, this.operatorInformation, this.idleTime, this.signOnTime, this.awayMessage);
        }
    }
}

