/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.element;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.element.DefaultStaleable;
import org.kitteh.irc.client.library.element.User;
import org.kitteh.irc.client.library.util.ToStringer;

public class DefaultUser
extends DefaultStaleable
implements User {
    private final String account;
    private final String awayMessage;
    private final Set<String> channels;
    private final String host;
    private final boolean isAway;
    private final String nick;
    private final String operString;
    private final String realName;
    private final String server;
    private final String user;

    public DefaultUser(@NonNull Client.WithManagement client, @NonNull String name, @Nullable String account, @Nullable String awayMessage, @NonNull String nick, @NonNull String user, @NonNull String host, boolean isAway, @Nullable String operString, @Nullable String realName, @Nullable String server, @NonNull Set<String> channels) {
        super(client, name);
        this.account = account;
        this.awayMessage = awayMessage;
        this.nick = nick;
        this.user = user;
        this.host = host;
        this.isAway = isAway;
        this.operString = operString;
        this.realName = realName;
        this.server = server;
        this.channels = Collections.unmodifiableSet(channels);
    }

    public boolean equals(Object o) {
        return o instanceof DefaultUser && ((DefaultUser)o).getClient() == this.getClient() && ((DefaultUser)o).getLowerCaseName().equals(this.getLowerCaseName());
    }

    @Override
    public @NonNull Optional<String> getAccount() {
        return Optional.ofNullable(this.account);
    }

    @Override
    public @NonNull Optional<String> getAwayMessage() {
        return Optional.ofNullable(this.awayMessage);
    }

    @Override
    public @NonNull Set<String> getChannels() {
        return this.channels;
    }

    @Override
    public @NonNull String getHost() {
        return this.host;
    }

    @Override
    public @NonNull String getMessagingName() {
        return this.getNick();
    }

    @Override
    public @NonNull String getNick() {
        return this.nick;
    }

    @Override
    public @NonNull Optional<String> getOperatorInformation() {
        return Optional.ofNullable(this.operString);
    }

    @Override
    public @NonNull Optional<String> getRealName() {
        return Optional.ofNullable(this.realName);
    }

    @Override
    public @NonNull Optional<String> getServer() {
        return Optional.ofNullable(this.server);
    }

    @Override
    public @NonNull String getUserString() {
        return this.user;
    }

    public int hashCode() {
        return this.getLowerCaseName().hashCode() * 2 + this.getClient().hashCode();
    }

    @Override
    public boolean isAway() {
        return this.isAway;
    }

    @Override
    public @NonNull String toString() {
        return new ToStringer(this).add("client", this.getClient()).add("nick", this.nick).add("user", this.user).add("host", this.host).add("channels", this.channels.size()).toString();
    }
}

