/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.element;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.command.ChannelModeCommand;
import org.kitteh.irc.client.library.command.KickCommand;
import org.kitteh.irc.client.library.command.TopicCommand;
import org.kitteh.irc.client.library.defaults.element.DefaultStaleable;
import org.kitteh.irc.client.library.element.Channel;
import org.kitteh.irc.client.library.element.User;
import org.kitteh.irc.client.library.element.mode.ChannelMode;
import org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import org.kitteh.irc.client.library.element.mode.ModeInfo;
import org.kitteh.irc.client.library.element.mode.ModeStatusList;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class DefaultChannel
extends DefaultStaleable
implements Channel {
    private final ModeStatusList<ChannelMode> channelModes;
    private final Map<Character, List<ModeInfo>> modeInfoLists;
    private final Map<String, SortedSet<ChannelUserMode>> modes;
    private final List<String> names;
    private final Map<String, User> nickMap;
    private final List<User> users;
    private final boolean complete;
    private final Channel.Topic topic;
    private final DefaultChannelCommands commands;

    public DefaultChannel(@NonNull Client.WithManagement client, @NonNull String name, @NonNull Channel.Topic topic, @NonNull ModeStatusList<ChannelMode> channelModes, @NonNull Map<Character, List<ModeInfo>> modeInfoLists, @NonNull Map<String, SortedSet<ChannelUserMode>> modes, @NonNull List<String> names, @NonNull Map<String, User> nickMap, @NonNull List<User> users, boolean complete, @NonNull DefaultChannelCommands commands) {
        super(client, name);
        this.complete = complete;
        this.channelModes = channelModes;
        this.topic = topic;
        this.commands = commands;
        this.modeInfoLists = modeInfoLists;
        this.modes = Collections.unmodifiableMap(modes);
        this.names = Collections.unmodifiableList(names);
        this.nickMap = Collections.unmodifiableMap(nickMap);
        this.users = Collections.unmodifiableList(users);
    }

    public boolean equals(Object o) {
        return o instanceof DefaultChannel && ((DefaultChannel)o).getClient() == this.getClient() && ((Channel)o).getLowerCaseName().equals(this.getLowerCaseName());
    }

    @Override
    public @NonNull String getMessagingName() {
        return this.getName();
    }

    @Override
    public @NonNull Optional<List<ModeInfo>> getModeInfoList(@NonNull ChannelMode mode) {
        Sanity.nullCheck(mode, "Mode");
        Sanity.truthiness(mode.getType() == ChannelMode.Type.A_MASK, "Mode type must be A, found " + (Object)((Object)mode.getType()));
        return Optional.ofNullable(this.modeInfoLists.get(Character.valueOf(mode.getChar())));
    }

    @Override
    public @NonNull ModeStatusList<ChannelMode> getModes() {
        return this.channelModes;
    }

    @Override
    public @NonNull List<String> getNicknames() {
        return this.names;
    }

    @Override
    public @NonNull Channel.Topic getTopic() {
        return this.topic;
    }

    @Override
    public @NonNull Optional<User> getUser(@NonNull String nick) {
        Sanity.nullCheck(nick, "Nick");
        return Optional.ofNullable(this.nickMap.get(nick));
    }

    @Override
    public @NonNull Optional<SortedSet<ChannelUserMode>> getUserModes(@NonNull String nick) {
        Sanity.nullCheck(nick, "Nick");
        return Optional.ofNullable(this.modes.get(nick));
    }

    @Override
    public @NonNull List<User> getUsers() {
        return this.users;
    }

    @Override
    public boolean hasCompleteUserData() {
        return this.complete;
    }

    @Override
    public void setModeInfoTracking(@NonNull ChannelMode mode, boolean track) {
        Sanity.nullCheck(mode, "Mode");
        Sanity.truthiness(mode.getType() == ChannelMode.Type.A_MASK, "Mode type must be A, found " + (Object)((Object)mode.getType()));
        Sanity.truthiness(mode.getChar() == 'b' || mode.getChar() == 'e' || mode.getChar() == 'I' || mode.getChar() == 'q', "Only modes b, e, I, and q supported");
        Optional<Channel> channel = this.getClient().getActorTracker().getTrackedChannel(this.getName());
        if (!channel.isPresent()) {
            throw new IllegalStateException("Not currently in channel " + this.getName());
        }
        this.getClient().getActorTracker().trackChannelMode(channel.get().getName(), mode, track);
    }

    @Override
    public @NonNull Channel.Commands commands() {
        return this.commands;
    }

    public int hashCode() {
        return this.getLowerCaseName().hashCode() * 2 + this.getClient().hashCode();
    }

    @Override
    public @NonNull String toString() {
        return new ToStringer(this).add("client", this.getClient()).add("name", this.getName()).add("complete", this.complete).add("users", this.users.size()).toString();
    }

    public static class DefaultChannelCommands
    implements Channel.Commands {
        private final String channel;
        private final Client client;

        public DefaultChannelCommands(@NonNull Client client, @NonNull String channel) {
            this.client = client;
            this.channel = channel;
        }

        @Override
        public @NonNull ChannelModeCommand mode() {
            return new ChannelModeCommand(this.client, this.channel);
        }

        @Override
        public @NonNull KickCommand kick() {
            return new KickCommand(this.client, this.channel);
        }

        @Override
        public @NonNull TopicCommand topic() {
            return new TopicCommand(this.client, this.channel);
        }
    }
}

