/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.command.Command;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class MonitorCommand
extends Command<MonitorCommand> {
    private Action action;
    private Set<String> targets;

    public MonitorCommand(@NonNull Client client) {
        super(client);
    }

    public @NonNull MonitorCommand action(@NonNull Action action) {
        this.action = Sanity.nullCheck(action, "Action");
        return this;
    }

    public @NonNull MonitorCommand target(String ... targets) {
        return this.target(Arrays.asList(Sanity.nullCheck(targets, "Targets")));
    }

    public synchronized @NonNull MonitorCommand target(@NonNull Collection<String> targets) {
        Sanity.nullCheck(targets, "Targets");
        LinkedHashSet<String> targetSet = new LinkedHashSet<String>();
        for (String target : targets) {
            Sanity.safeMessageCheck(target, "target");
            Sanity.truthiness(target.indexOf(44) == -1, "Target cannot contain a comma");
            targetSet.add(target);
        }
        this.targets = targetSet;
        return this;
    }

    @Override
    public synchronized void execute() {
        if (this.action == null) {
            throw new IllegalStateException("Action not defined");
        }
        if (this.action == Action.ADD_TARGET || this.action == Action.REMOVE_TARGET) {
            if (this.targets == null || this.targets.isEmpty()) {
                throw new IllegalStateException("Target(s) not defined");
            }
            StringBuilder builder = new StringBuilder(200);
            for (String request : this.targets) {
                if (builder.length() > 0 && request.length() + builder.length() > 200) {
                    this.monitorCommand(this.action, builder.toString());
                    builder.setLength(0);
                }
                if (builder.length() > 0) {
                    builder.append(',');
                }
                builder.append(request);
            }
            this.monitorCommand(this.action, builder.toString());
        } else {
            this.monitorCommand(this.action);
        }
    }

    private void monitorCommand(@NonNull Action action) {
        this.sendCommandLine("MONITOR " + action.getCharacter());
    }

    private void monitorCommand(@NonNull Action action, @NonNull String targets) {
        this.sendCommandLine("MONITOR " + action.getCharacter() + ' ' + targets);
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("action", (Object)this.action).add("targets", this.targets);
    }

    public static enum Action {
        ADD_TARGET('+'),
        CLEAR_ALL_TARGETS('C'),
        LIST_TARGETS('L'),
        REMOVE_TARGET('-'),
        STATUS_OUTPUT_ALL('S');

        private final char character;

        private Action(char character) {
            this.character = character;
        }

        public char getCharacter() {
            return this.character;
        }
    }
}

