/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.util.FilenameUtils;
import org.apache.maven.scm.util.ThreadSafeDateFormat;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSet
implements Serializable {
    private static final long serialVersionUID = 7097705862222539801L;
    public static final String LESS_THAN_ENTITY = "&lt;";
    public static final String GREATER_THAN_ENTITY = "&gt;";
    public static final String AMPERSAND_ENTITY = "&amp;";
    public static final String APOSTROPHE_ENTITY = "&apos;";
    public static final String QUOTE_ENTITY = "&quot;";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final ThreadSafeDateFormat DATE_FORMAT = new ThreadSafeDateFormat("yyyy-MM-dd");
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final ThreadSafeDateFormat TIME_FORMAT = new ThreadSafeDateFormat("HH:mm:ss");
    private static final ThreadSafeDateFormat TIMESTAMP_FORMAT_1 = new ThreadSafeDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final ThreadSafeDateFormat TIMESTAMP_FORMAT_2 = new ThreadSafeDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final ThreadSafeDateFormat TIMESTAMP_FORMAT_3 = new ThreadSafeDateFormat("yyyy/MM/dd HH:mm:ss z");
    private static final ThreadSafeDateFormat TIMESTAMP_FORMAT_4 = new ThreadSafeDateFormat("yyyy-MM-dd HH:mm:ss z");
    private Date date;
    private String author;
    private String comment = "";
    private List<ChangeFile> files;
    private String revision;
    private String parentRevision;
    private Set<String> mergedRevisions;

    public ChangeSet(String strDate, String userDatePattern, String comment, String author, List<ChangeFile> files) {
        this(null, comment, author, files);
        this.setDate(strDate, userDatePattern);
    }

    public ChangeSet(Date date, String comment, String author, List<ChangeFile> files) {
        this.setDate(date);
        this.setAuthor(author);
        this.setComment(comment);
        this.files = files;
    }

    public ChangeSet() {
    }

    public List<ChangeFile> getFiles() {
        if (this.files == null) {
            return new ArrayList<ChangeFile>();
        }
        return this.files;
    }

    public void setFiles(List<ChangeFile> files) {
        this.files = files;
    }

    public void addFile(ChangeFile file) {
        if (this.files == null) {
            this.files = new ArrayList<ChangeFile>();
        }
        this.files.add(file);
    }

    public boolean containsFilename(String filename, ScmProviderRepository repository) {
        return this.containsFilename(filename);
    }

    public boolean containsFilename(String filename) {
        if (this.files != null) {
            for (ChangeFile file : this.files) {
                String f2;
                String f1 = FilenameUtils.normalizeFilename(file.getName());
                if (f1.indexOf(f2 = FilenameUtils.normalizeFilename(filename)) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Date getDate() {
        if (this.date != null) {
            return (Date)this.date.clone();
        }
        return null;
    }

    public void setDate(Date date) {
        if (date != null) {
            this.date = new Date(date.getTime());
        }
    }

    public void setDate(String date) {
        this.setDate(date, null);
    }

    public void setDate(String date, String userDatePattern) {
        block19: {
            try {
                if (!StringUtils.isEmpty((String)userDatePattern)) {
                    SimpleDateFormat format = new SimpleDateFormat(userDatePattern);
                    this.date = format.parse(date);
                } else {
                    this.date = TIMESTAMP_FORMAT_3.parse(date);
                }
            }
            catch (ParseException e) {
                if (!StringUtils.isEmpty((String)userDatePattern)) {
                    try {
                        this.date = TIMESTAMP_FORMAT_3.parse(date);
                    }
                    catch (ParseException pe) {
                        try {
                            this.date = TIMESTAMP_FORMAT_4.parse(date);
                            break block19;
                        }
                        catch (ParseException pe1) {
                            try {
                                this.date = TIMESTAMP_FORMAT_1.parse(date);
                                break block19;
                            }
                            catch (ParseException pe2) {
                                try {
                                    this.date = TIMESTAMP_FORMAT_2.parse(date);
                                    break block19;
                                }
                                catch (ParseException pe3) {
                                    throw new IllegalArgumentException("Unable to parse date: " + date);
                                }
                            }
                        }
                    }
                }
                try {
                    this.date = TIMESTAMP_FORMAT_4.parse(date);
                }
                catch (ParseException pe1) {
                    try {
                        this.date = TIMESTAMP_FORMAT_1.parse(date);
                    }
                    catch (ParseException pe2) {
                        try {
                            this.date = TIMESTAMP_FORMAT_2.parse(date);
                        }
                        catch (ParseException pe3) {
                            throw new IllegalArgumentException("Unable to parse date: " + date);
                        }
                    }
                }
            }
        }
    }

    public String getDateFormatted() {
        return DATE_FORMAT.format(this.getDate());
    }

    public String getTimeFormatted() {
        return TIME_FORMAT.format(this.getDate());
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getParentRevision() {
        return this.parentRevision;
    }

    public void setParentRevision(String parentRevision) {
        this.parentRevision = parentRevision;
    }

    public void addMergedRevision(String mergedRevision) {
        if (this.mergedRevisions == null) {
            this.mergedRevisions = new LinkedHashSet<String>();
        }
        this.mergedRevisions.add(mergedRevision);
    }

    public Set<String> getMergedRevisions() {
        return this.mergedRevisions == null ? Collections.emptySet() : this.mergedRevisions;
    }

    public void setMergedRevisions(Set<String> mergedRevisions) {
        this.mergedRevisions = mergedRevisions;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.author == null ? " null " : this.author);
        result.append("\n").append(this.date == null ? "null " : this.date.toString()).append("\n");
        if (this.parentRevision != null) {
            result.append("parent: ").append(this.parentRevision);
            if (!this.mergedRevisions.isEmpty()) {
                result.append(" + ");
                result.append(this.mergedRevisions);
            }
            result.append("\n");
        }
        if (this.files != null) {
            for (ChangeFile file : this.files) {
                result.append(file == null ? " null " : file.toString()).append("\n");
            }
        }
        result.append(this.comment == null ? " null " : this.comment);
        return result.toString();
    }

    public String toXML() {
        StringBuilder buffer = new StringBuilder("\t<changelog-entry>\n");
        if (this.getDate() != null) {
            buffer.append("\t\t<date pattern=\"yyyy-MM-dd\">").append(this.getDateFormatted()).append("</date>\n").append("\t\t<time pattern=\"HH:mm:ss\">").append(this.getTimeFormatted()).append("</time>\n");
        }
        buffer.append("\t\t<author><![CDATA[").append(this.author).append("]]></author>\n");
        if (this.parentRevision != null) {
            buffer.append("\t\t<parent>").append(this.getParentRevision()).append("</parent>\n");
        }
        for (String mergedRevision : this.getMergedRevisions()) {
            buffer.append("\t\t<merge>").append(mergedRevision).append("</merge>\n");
        }
        if (this.files != null) {
            for (ChangeFile file : this.files) {
                buffer.append("\t\t<file>\n");
                if (file.getAction() != null) {
                    buffer.append("\t\t\t<action>").append(file.getAction()).append("</action>\n");
                }
                buffer.append("\t\t\t<name>").append(ChangeSet.escapeValue(file.getName())).append("</name>\n");
                buffer.append("\t\t\t<revision>").append(file.getRevision()).append("</revision>\n");
                if (file.getOriginalName() != null) {
                    buffer.append("\t\t\t<orig-name>");
                    buffer.append(ChangeSet.escapeValue(file.getOriginalName()));
                    buffer.append("</orig-name>\n");
                }
                if (file.getOriginalRevision() != null) {
                    buffer.append("\t\t\t<orig-revision>");
                    buffer.append(file.getOriginalRevision());
                    buffer.append("</orig-revision>\n");
                }
                buffer.append("\t\t</file>\n");
            }
        }
        buffer.append("\t\t<msg><![CDATA[").append(this.removeCDataEnd(this.comment)).append("]]></msg>\n");
        buffer.append("\t</changelog-entry>\n");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChangeSet) {
            ChangeSet changeSet = (ChangeSet)obj;
            if (this.toString().equals(changeSet.toString())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.parentRevision == null ? 0 : this.parentRevision.hashCode());
        result = 31 * result + (this.mergedRevisions == null ? 0 : this.mergedRevisions.hashCode());
        result = 31 * result + (this.files == null ? 0 : this.files.hashCode());
        return result;
    }

    private String removeCDataEnd(String message) {
        int endCdata;
        while (message != null && (endCdata = message.indexOf("]]>")) > -1) {
            message = message.substring(0, endCdata) + "] ] >" + message.substring(endCdata + 3, message.length());
        }
        return message;
    }

    public static String escapeValue(Object value) {
        StringBuilder buffer = new StringBuilder(value.toString());
        int size = buffer.length();
        block7: for (int i = 0; i < size; ++i) {
            switch (buffer.charAt(i)) {
                case '<': {
                    buffer.replace(i, i + 1, LESS_THAN_ENTITY);
                    size += 3;
                    i += 3;
                    continue block7;
                }
                case '>': {
                    buffer.replace(i, i + 1, GREATER_THAN_ENTITY);
                    size += 3;
                    i += 3;
                    continue block7;
                }
                case '&': {
                    buffer.replace(i, i + 1, AMPERSAND_ENTITY);
                    size += 4;
                    i += 4;
                    continue block7;
                }
                case '\'': {
                    buffer.replace(i, i + 1, APOSTROPHE_ENTITY);
                    size += 5;
                    i += 5;
                    continue block7;
                }
                case '\"': {
                    buffer.replace(i, i + 1, QUOTE_ENTITY);
                    size += 5;
                    i += 5;
                    continue block7;
                }
            }
        }
        return buffer.toString();
    }
}

