/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource.mavenplugin;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import net.md_5.specialsource.AccessMap;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.RemapperProcessor;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.util.FileLocator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

@Mojo(name="install-remapped-file", defaultPhase=LifecyclePhase.INITIALIZE)
public class InstallRemappedFileMojo
extends AbstractMojo {
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactInstaller installer;
    @Parameter(property="localRepository", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(property="createChecksum", defaultValue="false")
    protected boolean createChecksum;
    @Parameter(property="updateReleaseInfo", defaultValue="false")
    protected boolean updateReleaseInfo;
    @Component(hint="md5")
    protected Digester md5Digester;
    @Component(hint="sha1")
    protected Digester sha1Digester;
    @Parameter(property="groupId", required=true)
    protected String groupId;
    @Parameter(property="artifactId", required=true)
    protected String artifactId;
    @Parameter(property="version", required=true)
    protected String version;
    @Parameter(property="packaging", defaultValue="jar")
    protected String packaging;
    @Parameter(property="classifier")
    protected String classifier;
    @Parameter(property="in-jars", required=true)
    private String[] inJars;
    @Parameter(property="javadoc")
    private File javadoc;
    @Parameter(property="sources")
    private File sources;
    @Parameter(required=true)
    private String srgIn;
    @Parameter
    private boolean reverse;
    @Parameter
    private boolean numeric;
    @Parameter
    private boolean generateAPI;
    @Parameter
    private String inShadeRelocation;
    @Parameter
    private String outShadeRelocation;
    @Parameter
    private String[] accessTransformers;
    @Parameter
    private String[] excludedPackages;
    @Parameter(defaultValue="false")
    private boolean replaceMainArtifact;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(defaultValue="false")
    private boolean attachArtifact;
    @Parameter(defaultValue="jar")
    private String attachArtifactType;
    @Parameter(defaultValue="")
    private String attachArtifactClassifier;
    @Parameter(defaultValue="true")
    private boolean installArtifact;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map repositoryLayouts;
    @Component
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private ModelValidator modelValidator;

    public void execute() throws MojoFailureException, MojoExecutionException {
        this.validateArtifactInformation();
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
        File existingFile = this.getLocalRepoFile(artifact);
        if (existingFile != null && existingFile.exists()) {
            System.out.println("Using cached remapped artifact " + existingFile.getPath());
            return;
        }
        File outJar = null;
        try {
            ArrayList<File> files = new ArrayList<File>();
            for (String filename : this.inJars) {
                files.add(FileLocator.getFile((String)filename));
            }
            Jar inJar = Jar.init(files);
            outJar = File.createTempFile(this.groupId + "." + this.artifactId + "-" + this.version, "." + this.packaging);
            JarMapping mapping = new JarMapping();
            if (this.excludedPackages != null) {
                for (String packageName : this.excludedPackages) {
                    mapping.addExcludedPackage(packageName);
                }
            }
            mapping.loadMappings(this.srgIn, this.reverse, this.numeric, this.inShadeRelocation, this.outShadeRelocation);
            mapping.setFallbackInheritanceProvider((InheritanceProvider)new JarProvider(inJar));
            RemapperProcessor preprocessor = null;
            if (this.accessTransformers != null) {
                AccessMap accessMap = new AccessMap();
                for (String filename : this.accessTransformers) {
                    if (filename == null || filename.length() == 0) continue;
                    accessMap.loadAccessTransformer(filename);
                }
                preprocessor = new RemapperProcessor(null, null, accessMap);
            }
            JarRemapper remapper = new JarRemapper(preprocessor, mapping);
            remapper.setGenerateAPI(this.generateAPI);
            remapper.remapJar(inJar, outJar);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new MojoExecutionException("Error creating remapped jar at " + outJar + ": " + ex.getMessage(), ex);
        }
        if (this.replaceMainArtifact) {
            this.getLog().info((CharSequence)"Replacing original artifact with remapped artifact.");
            File originalArtifact = this.project.getArtifact().getFile();
            originalArtifact.delete();
            if (!outJar.renameTo(originalArtifact)) {
                throw new MojoExecutionException("Error replacing remapped jar at " + originalArtifact + " with " + outJar);
            }
        }
        if (this.attachArtifact) {
            if (this.attachArtifactClassifier == null || this.attachArtifactClassifier.equals("")) {
                this.attachArtifactClassifier = null;
            }
            this.getLog().info((CharSequence)("Attaching artifact " + outJar.getPath()));
            this.projectHelper.attachArtifact(this.project, this.attachArtifactType, this.attachArtifactClassifier, outJar);
        }
        if (this.installArtifact) {
            this.installArtifact(artifact, outJar);
        }
    }

    private void installArtifact(Artifact artifact, File outJar) throws MojoExecutionException {
        File generatedPomFile = this.generatePomFile();
        ProjectArtifactMetadata pomMetadata = new ProjectArtifactMetadata(artifact, generatedPomFile);
        if (!this.getLocalRepoFile((ArtifactMetadata)pomMetadata).exists()) {
            this.getLog().debug((CharSequence)"Installing generated POM");
            artifact.addMetadata((ArtifactMetadata)pomMetadata);
        } else {
            this.getLog().debug((CharSequence)"Skipping installation of generated POM, already present in local repository");
        }
        if (this.updateReleaseInfo) {
            artifact.setRelease(true);
        }
        LinkedHashSet metadataFiles = new LinkedHashSet();
        try {
            this.installer.install(outJar, artifact, this.localRepository);
            this.installChecksums(artifact, metadataFiles);
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException("Error installing artifact '" + artifact.getDependencyConflictId() + "' at " + outJar + ": " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (generatedPomFile != null) {
                generatedPomFile.delete();
            }
        }
        if (this.sources != null) {
            artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, "jar", "sources");
            try {
                this.installer.install(this.sources, artifact, this.localRepository);
                this.installChecksums(artifact, metadataFiles);
            }
            catch (ArtifactInstallationException e) {
                throw new MojoExecutionException("Error installing sources " + this.sources + ": " + e.getMessage(), (Exception)((Object)e));
            }
        }
        if (this.javadoc != null) {
            artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, "jar", "javadoc");
            try {
                this.installer.install(this.javadoc, artifact, this.localRepository);
                this.installChecksums(artifact, metadataFiles);
            }
            catch (ArtifactInstallationException e) {
                throw new MojoExecutionException("Error installing API docs " + this.javadoc + ": " + e.getMessage(), (Exception)((Object)e));
            }
        }
        this.installChecksums(metadataFiles);
        outJar.delete();
    }

    private void validateArtifactInformation() throws MojoExecutionException {
        Model model = this.generateModel();
        ModelValidationResult result = this.modelValidator.validate(model);
        if (result.getMessageCount() > 0) {
            throw new MojoExecutionException("The artifact information is incomplete or not valid:\n" + result.render("  "));
        }
    }

    private Model generateModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setPackaging(this.packaging);
        model.setDescription("POM was created from specialsource-maven-plugin");
        return model;
    }

    private File generatePomFile() throws MojoExecutionException {
        File file;
        Model model = this.generateModel();
        XmlStreamWriter writer = null;
        try {
            File pomFile = File.createTempFile("mvninstall", ".pom");
            writer = WriterFactory.newXmlWriter((File)pomFile);
            new MavenXpp3Writer().write((Writer)writer, model);
            file = pomFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary POM file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        return file;
    }

    protected File getLocalRepoFile(Artifact artifact) {
        String path = this.localRepository.pathOf(artifact);
        return new File(this.localRepository.getBasedir(), path);
    }

    protected File getLocalRepoFile(ArtifactMetadata metadata) {
        String path = this.localRepository.pathOfLocalRepositoryMetadata(metadata, this.localRepository);
        return new File(this.localRepository.getBasedir(), path);
    }

    protected void installChecksums(Artifact artifact, Collection metadataFiles) throws MojoExecutionException {
        if (!this.createChecksum) {
            return;
        }
        File artifactFile = this.getLocalRepoFile(artifact);
        this.installChecksums(artifactFile);
        Collection metadatas = artifact.getMetadataList();
        if (metadatas != null) {
            for (ArtifactMetadata metadata : metadatas) {
                File metadataFile = this.getLocalRepoFile(metadata);
                metadataFiles.add(metadataFile);
            }
        }
    }

    protected void installChecksums(Collection metadataFiles) throws MojoExecutionException {
        for (File metadataFile : metadataFiles) {
            this.installChecksums(metadataFile);
        }
    }

    private void installChecksums(File installedFile) throws MojoExecutionException {
        boolean signatureFile = installedFile.getName().endsWith(".asc");
        if (installedFile.isFile() && !signatureFile) {
            this.installChecksum(installedFile, installedFile, this.md5Digester, ".md5");
            this.installChecksum(installedFile, installedFile, this.sha1Digester, ".sha1");
        }
    }

    private void installChecksum(File originalFile, File installedFile, Digester digester, String ext) throws MojoExecutionException {
        String checksum;
        this.getLog().debug((CharSequence)("Calculating " + digester.getAlgorithm() + " checksum for " + originalFile));
        try {
            checksum = digester.calc(originalFile);
        }
        catch (DigesterException e) {
            throw new MojoExecutionException("Failed to calculate " + digester.getAlgorithm() + " checksum for " + originalFile, (Exception)((Object)e));
        }
        File checksumFile = new File(installedFile.getAbsolutePath() + ext);
        this.getLog().debug((CharSequence)("Installing checksum to " + checksumFile));
        try {
            checksumFile.getParentFile().mkdirs();
            FileUtils.fileWrite((String)checksumFile.getAbsolutePath(), (String)"UTF-8", (String)checksum);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to install checksum to " + checksumFile, (Exception)e);
        }
    }
}

