/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.query;

import java.util.Locale;
import java.util.Objects;
import net.luckperms.api.query.OptionKey;
import org.checkerframework.checker.nullness.qual.NonNull;

final class SimpleOptionKey<T>
implements OptionKey<T> {
    private final String name;
    private final Class<T> type;
    private final int hashCode;

    SimpleOptionKey(String name, Class<T> type) {
        this.name = name.toLowerCase(Locale.ROOT);
        this.type = type;
        this.hashCode = Objects.hash(this.name, this.type);
    }

    @Override
    public @NonNull String name() {
        return this.name;
    }

    @Override
    public @NonNull Class<T> type() {
        return this.type;
    }

    public String toString() {
        return "OptionKey(name=" + this.name + ", type=" + this.type.getName() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleOptionKey that = (SimpleOptionKey)o;
        return this.name.equals(that.name) && this.type.equals(that.type);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

