/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.context;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.context.MutableContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface ContextSet
extends Iterable<Context> {
    public boolean isImmutable();

    public @NonNull ImmutableContextSet immutableCopy();

    public @NonNull MutableContextSet mutableCopy();

    public @NonNull Set<Context> toSet();

    public @NonNull Map<String, Set<String>> toMap();

    @Deprecated
    public @NonNull Map<String, String> toFlattenedMap();

    @Override
    public @NonNull Iterator<Context> iterator();

    public boolean containsKey(@NonNull String var1);

    public @NonNull Set<String> getValues(@NonNull String var1);

    default public @NonNull Optional<String> getAnyValue(@NonNull String key) {
        return this.getValues(key).stream().findAny();
    }

    public boolean contains(@NonNull String var1, @NonNull String var2);

    default public boolean contains(@NonNull Context entry) {
        Objects.requireNonNull(entry, "entry");
        return this.contains(entry.getKey(), entry.getValue());
    }

    public boolean isSatisfiedBy(@NonNull ContextSet var1);

    public boolean isEmpty();

    public int size();
}

