/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.serializer.legacy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.kyori.text.BuildableComponent;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import net.kyori.text.format.TextColor;
import net.kyori.text.format.TextDecoration;
import net.kyori.text.format.TextFormat;
import net.kyori.text.serializer.legacy.LegacyComponentSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class LegacyComponentSerializerImpl
implements LegacyComponentSerializer {
    private static final TextDecoration[] DECORATIONS = TextDecoration.values();
    private static final String LEGACY_CHARS = "0123456789abcdefklmnor";
    private static final List<TextFormat> FORMATS;

    LegacyComponentSerializerImpl() {
    }

    private static @Nullable TextFormat formatByLegacyChar(char legacy) {
        int index = LEGACY_CHARS.indexOf(legacy);
        return index == -1 ? null : FORMATS.get(index);
    }

    private static char getLegacyChar(TextFormat legacy) {
        int index = FORMATS.indexOf(legacy);
        return LEGACY_CHARS.charAt(index);
    }

    @Override
    public @NonNull TextComponent deserialize(@NonNull String input, char character) {
        int next = input.lastIndexOf(character, input.length() - 2);
        if (next == -1) {
            return TextComponent.of((String)input);
        }
        ArrayList<BuildableComponent> parts = new ArrayList<BuildableComponent>();
        TextComponent.Builder current = null;
        boolean reset = false;
        int pos = input.length();
        do {
            TextFormat format;
            if ((format = LegacyComponentSerializerImpl.formatByLegacyChar(input.charAt(next + 1))) == null) continue;
            int from = next + 2;
            if (from != pos) {
                if (current != null) {
                    if (reset) {
                        parts.add(current.build());
                        reset = false;
                        current = TextComponent.builder((String)"");
                    } else {
                        current = (TextComponent.Builder)TextComponent.builder((String)"").append((Component)current.build());
                    }
                } else {
                    current = TextComponent.builder((String)"");
                }
                current.content(input.substring(from, pos));
            } else if (current == null) {
                current = TextComponent.builder((String)"");
            }
            reset |= LegacyComponentSerializerImpl.applyFormat(current, format);
            pos = next;
        } while ((next = input.lastIndexOf(character, next - 1)) != -1);
        if (current != null) {
            parts.add(current.build());
        }
        Collections.reverse(parts);
        return (TextComponent)((TextComponent.Builder)TextComponent.builder((String)(pos > 0 ? input.substring(0, pos) : "")).append(parts)).build();
    }

    @Override
    public @NonNull String serialize(@NonNull Component component, char character) {
        Cereal state = new Cereal(character);
        state.append(component);
        return state.toString();
    }

    private static boolean applyFormat(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TextComponent.Builder builder, @NonNull TextFormat format) {
        if (format instanceof TextColor) {
            builder.colorIfAbsent((TextColor)format);
            return true;
        }
        if (format instanceof TextDecoration) {
            builder.decoration((TextDecoration)format, TextDecoration.State.TRUE);
            return false;
        }
        if (format instanceof Reset) {
            builder.colorIfAbsent(null);
            for (TextDecoration decoration : DECORATIONS) {
                builder.decoration(decoration, TextDecoration.State.NOT_SET);
            }
            return true;
        }
        throw new IllegalArgumentException(String.format("unknown format '%s'", format.getClass()));
    }

    static {
        ArrayList<Reset> formats = new ArrayList<Reset>();
        Collections.addAll(formats, TextColor.values());
        Collections.addAll(formats, DECORATIONS);
        formats.add(Reset.INSTANCE);
        FORMATS = Collections.unmodifiableList(formats);
        if (FORMATS.size() != LEGACY_CHARS.length()) {
            throw new IllegalStateException("FORMATS length differs from LEGACY_CHARS length");
        }
    }

    private static final class Cereal {
        private final StringBuilder sb = new StringBuilder();
        private final Style style = new Style();
        private final char character;

        Cereal(char character) {
            this.character = character;
        }

        void append(@NonNull Component component) {
            this.append(component, new Style());
        }

        private void append(@NonNull Component component, @NonNull Style style) {
            List children;
            String content;
            style.apply(component);
            if (component instanceof TextComponent && !(content = ((TextComponent)component).content()).isEmpty()) {
                style.applyFormat();
                this.sb.append(content);
            }
            if (!(children = component.children()).isEmpty()) {
                Style childrenStyle = new Style(style);
                for (Component child : component.children()) {
                    this.append(child, childrenStyle);
                    childrenStyle.set(style);
                }
            }
        }

        private void append(@NonNull TextFormat format) {
            this.sb.append(this.character).append(LegacyComponentSerializerImpl.getLegacyChar(format));
        }

        public String toString() {
            return this.sb.toString();
        }

        private final class Style {
            private @Nullable TextColor color;
            private final Set<TextDecoration> decorations;

            Style() {
                this.decorations = EnumSet.noneOf(TextDecoration.class);
            }

            Style(Style that) {
                this.color = that.color;
                this.decorations = EnumSet.copyOf(that.decorations);
            }

            void set(@NonNull Style that) {
                this.color = that.color;
                this.decorations.clear();
                this.decorations.addAll(that.decorations);
            }

            void apply(@NonNull Component component) {
                if (component.color() != null) {
                    this.color = component.color();
                }
                block4: for (TextDecoration decoration : DECORATIONS) {
                    switch (component.decoration(decoration)) {
                        case TRUE: {
                            this.decorations.add(decoration);
                            continue block4;
                        }
                        case FALSE: {
                            this.decorations.remove(decoration);
                        }
                    }
                }
            }

            void applyFormat() {
                if (this.color != ((Cereal)Cereal.this).style.color) {
                    this.applyFullFormat();
                    return;
                }
                if (!this.decorations.containsAll(((Cereal)Cereal.this).style.decorations)) {
                    this.applyFullFormat();
                    return;
                }
                for (TextDecoration decoration : this.decorations) {
                    if (!((Cereal)Cereal.this).style.decorations.add(decoration)) continue;
                    Cereal.this.append((TextFormat)decoration);
                }
            }

            private void applyFullFormat() {
                if (this.color != null) {
                    Cereal.this.append((TextFormat)this.color);
                } else {
                    Cereal.this.append(Reset.INSTANCE);
                }
                ((Cereal)Cereal.this).style.color = this.color;
                for (TextDecoration decoration : this.decorations) {
                    Cereal.this.append((TextFormat)decoration);
                }
                ((Cereal)Cereal.this).style.decorations.clear();
                ((Cereal)Cereal.this).style.decorations.addAll(this.decorations);
            }
        }
    }

    private static enum Reset implements TextFormat
    {
        INSTANCE;

    }
}

