/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.macosx;

import java.net.URI;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.macosx.OsxKeyManager;
import net.java.truecommons.key.spec.KeyProvider;
import net.java.truecommons.key.spec.UnknownKeyException;
import net.java.truecommons.key.spec.prompting.AbstractPromptingPbeParameters;
import net.java.truecommons.shed.Option;

@ThreadSafe
final class OsxKeyProvider<P extends AbstractPromptingPbeParameters<P, ?>>
implements KeyProvider<P> {
    private final OsxKeyManager<P> manager;
    private final URI resource;
    private final KeyProvider<P> provider;
    private volatile Option<P> param = Option.none();

    OsxKeyProvider(OsxKeyManager<P> manager, URI resource, KeyProvider<P> provider) {
        this.manager = manager;
        this.resource = resource;
        this.provider = provider;
    }

    public P getKeyForWriting() throws UnknownKeyException {
        Option<P> op = this.param;
        if (op.isEmpty()) {
            op = this.manager.getKey(this.resource);
        }
        for (AbstractPromptingPbeParameters p : op) {
            if (p.isChangeRequested()) continue;
            return (P)((AbstractPromptingPbeParameters)p.clone());
        }
        Option np = Option.some((Object)this.provider.getKeyForWriting());
        if (!np.equals(op)) {
            this.manager.setKey(this.resource, np);
        }
        this.param = np;
        return (P)((AbstractPromptingPbeParameters)this.param.get());
    }

    public P getKeyForReading(boolean invalid) throws UnknownKeyException {
        if (!invalid) {
            Iterator i$;
            Option<P> op = this.param;
            if (op.isEmpty()) {
                op = this.manager.getKey(this.resource);
            }
            if ((i$ = op.iterator()).hasNext()) {
                AbstractPromptingPbeParameters p = (AbstractPromptingPbeParameters)i$.next();
                return (P)((AbstractPromptingPbeParameters)p.clone());
            }
        }
        return (P)((AbstractPromptingPbeParameters)this.provider.getKeyForReading(invalid));
    }

    public void setKey(@Nullable P key) {
        Option<P> op = this.param;
        Option np = Option.apply(key);
        this.provider.setKey(key);
        if (!Objects.equals(np, op)) {
            this.manager.setKey(this.resource, np);
        }
        this.param = np;
    }
}

