/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import me.lucko.luckperms.api.context.ContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

abstract class AbstractContextSet
implements ContextSet {
    AbstractContextSet() {
    }

    protected abstract SetMultimap<String, String> backing();

    protected abstract void copyTo(SetMultimap<String, String> var1);

    @Override
    public boolean containsKey(@NonNull String key) {
        return this.backing().containsKey((Object)AbstractContextSet.sanitizeKey(key));
    }

    @Override
    public @NonNull Set<String> getValues(@NonNull String key) {
        Collection values = (Collection)this.backing().asMap().get(AbstractContextSet.sanitizeKey(key));
        return values != null ? ImmutableSet.copyOf((Collection)values) : ImmutableSet.of();
    }

    @Override
    public boolean has(@NonNull String key, @NonNull String value) {
        return this.backing().containsEntry((Object)AbstractContextSet.sanitizeKey(key), (Object)AbstractContextSet.sanitizeValue(value));
    }

    @Override
    public boolean isEmpty() {
        return this.backing().isEmpty();
    }

    @Override
    public int size() {
        return this.backing().size();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        ContextSet that = (ContextSet)o;
        Object otherContexts = that instanceof AbstractContextSet ? ((AbstractContextSet)that).backing() : that.toMultimap();
        return this.backing().equals(otherContexts);
    }

    public int hashCode() {
        return this.backing().hashCode();
    }

    static String sanitizeKey(String key) {
        Objects.requireNonNull(key, "key is null");
        if (AbstractContextSet.stringIsEmpty(key)) {
            throw new IllegalArgumentException("key is (effectively) empty");
        }
        return key.toLowerCase();
    }

    static String sanitizeValue(String value) {
        Objects.requireNonNull(value, "value is null");
        if (AbstractContextSet.stringIsEmpty(value)) {
            throw new IllegalArgumentException("value is (effectively) empty");
        }
        return value.toLowerCase();
    }

    private static boolean stringIsEmpty(String s) {
        if (s.isEmpty()) {
            return true;
        }
        for (char c : s.toCharArray()) {
            if (c == ' ') continue;
            return false;
        }
        return true;
    }
}

