/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.manager;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.luckperms.api.HeldPermission;
import me.lucko.luckperms.api.PlayerSaveResult;
import me.lucko.luckperms.api.User;

public interface UserManager {
    @Nonnull
    public CompletableFuture<User> loadUser(@Nonnull UUID var1, @Nullable String var2);

    @Nonnull
    default public CompletableFuture<User> loadUser(@Nonnull UUID uuid) {
        return this.loadUser(uuid, null);
    }

    @Nonnull
    public CompletableFuture<UUID> lookupUuid(@Nonnull String var1);

    @Nonnull
    public CompletableFuture<String> lookupUsername(@Nonnull UUID var1);

    @Nonnull
    public CompletableFuture<Void> saveUser(@Nonnull User var1);

    @Nonnull
    public CompletableFuture<PlayerSaveResult> savePlayerData(@Nonnull UUID var1, @Nonnull String var2);

    @Nonnull
    public CompletableFuture<Set<UUID>> getUniqueUsers();

    @Nonnull
    public CompletableFuture<List<HeldPermission<UUID>>> getWithPermission(@Nonnull String var1);

    @Nullable
    public User getUser(@Nonnull UUID var1);

    @Nonnull
    default public Optional<User> getUserOpt(@Nonnull UUID uuid) {
        return Optional.ofNullable(this.getUser(uuid));
    }

    @Nullable
    public User getUser(@Nonnull String var1);

    @Nonnull
    default public Optional<User> getUserOpt(@Nonnull String name) {
        return Optional.ofNullable(this.getUser(name));
    }

    @Nonnull
    public Set<User> getLoadedUsers();

    public boolean isLoaded(@Nonnull UUID var1);

    public void cleanupUser(@Nonnull User var1);
}

