/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import me.lucko.luckperms.api.NodeEqualityPredicate;
import me.lucko.luckperms.api.StandardNodeEquality;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.nodetype.NodeType;
import me.lucko.luckperms.api.nodetype.NodeTypeKey;
import me.lucko.luckperms.api.nodetype.types.InheritanceType;
import me.lucko.luckperms.api.nodetype.types.MetaType;
import me.lucko.luckperms.api.nodetype.types.PrefixType;
import me.lucko.luckperms.api.nodetype.types.SuffixType;

@Immutable
public interface Node {
    @Nonnull
    public String getPermission();

    public boolean getValue();

    @Nonnull
    default public Tristate getTristate() {
        return Tristate.fromBoolean(this.getValue());
    }

    default public boolean isNegated() {
        return !this.getValue();
    }

    public boolean isOverride();

    @Nonnull
    public Optional<String> getServer();

    @Nonnull
    public Optional<String> getWorld();

    public boolean isServerSpecific();

    public boolean isWorldSpecific();

    public boolean appliesGlobally();

    public boolean hasSpecificContext();

    public boolean shouldApplyWithContext(@Nonnull ContextSet var1);

    @Nonnull
    public List<String> resolveShorthand();

    public boolean isTemporary();

    default public boolean isPermanent() {
        return !this.isTemporary();
    }

    public long getExpiryUnixTime() throws IllegalStateException;

    @Nonnull
    public Date getExpiry() throws IllegalStateException;

    public long getSecondsTilExpiry() throws IllegalStateException;

    public boolean hasExpired();

    @Nonnull
    public ContextSet getContexts();

    @Nonnull
    public ContextSet getFullContexts();

    public boolean isWildcard();

    public int getWildcardLevel() throws IllegalStateException;

    public boolean hasTypeData();

    public <T extends NodeType> Optional<T> getTypeData(NodeTypeKey<T> var1);

    default public <T extends NodeType> T typeData(NodeTypeKey<T> key) throws IllegalStateException {
        return (T)((NodeType)this.getTypeData(key).orElseThrow(() -> new IllegalStateException("Node '" + this.getPermission() + "' does not have the '" + key.getTypeName() + "' type.")));
    }

    default public boolean isGroupNode() {
        return this.getTypeData(InheritanceType.KEY).isPresent();
    }

    @Nonnull
    default public String getGroupName() throws IllegalStateException {
        return this.typeData(InheritanceType.KEY).getGroupName();
    }

    default public boolean isMeta() {
        return this.getTypeData(MetaType.KEY).isPresent();
    }

    @Nonnull
    default public Map.Entry<String, String> getMeta() throws IllegalStateException {
        return this.typeData(MetaType.KEY);
    }

    default public boolean isPrefix() {
        return this.getTypeData(PrefixType.KEY).isPresent();
    }

    @Nonnull
    default public Map.Entry<Integer, String> getPrefix() throws IllegalStateException {
        return this.typeData(PrefixType.KEY).getAsEntry();
    }

    default public boolean isSuffix() {
        return this.getTypeData(SuffixType.KEY).isPresent();
    }

    @Nonnull
    default public Map.Entry<Integer, String> getSuffix() throws IllegalStateException {
        return this.typeData(SuffixType.KEY).getAsEntry();
    }

    public boolean equals(Object var1);

    public boolean standardEquals(Node var1, StandardNodeEquality var2);

    default public boolean equals(Node other, NodeEqualityPredicate equalityPredicate) {
        return equalityPredicate.areEqual(this, other);
    }

    @Deprecated
    default public boolean equalsIgnoringValue(@Nonnull Node other) {
        return this.equals(other, StandardNodeEquality.IGNORE_VALUE);
    }

    @Deprecated
    default public boolean almostEquals(@Nonnull Node other) {
        return this.equals(other, StandardNodeEquality.IGNORE_EXPIRY_TIME_AND_VALUE);
    }

    @Deprecated
    default public boolean equalsIgnoringValueOrTemp(@Nonnull Node other) {
        return this.equals(other, StandardNodeEquality.IGNORE_VALUE_OR_IF_TEMPORARY);
    }

    public Builder toBuilder();

    public static interface Builder {
        public Builder copyFrom(@Nonnull Node var1);

        @Nonnull
        public Builder setNegated(boolean var1);

        @Nonnull
        public Builder setValue(boolean var1);

        @Nonnull
        public Builder setOverride(boolean var1);

        @Nonnull
        public Builder setExpiry(long var1);

        @Nonnull
        default public Builder setExpiry(long duration, TimeUnit unit) {
            Preconditions.checkArgument((duration > 0L ? 1 : 0) != 0, (Object)"duration must be positive");
            long seconds = Objects.requireNonNull(unit, "unit").toSeconds(duration);
            long timeNow = System.currentTimeMillis() / 1000L;
            return this.setExpiry(timeNow + seconds);
        }

        @Nonnull
        public Builder clearExpiry();

        @Nonnull
        public Builder setWorld(@Nullable String var1);

        @Nonnull
        public Builder setServer(@Nullable String var1);

        @Nonnull
        public Builder withExtraContext(@Nonnull String var1, @Nonnull String var2);

        @Nonnull
        public Builder withExtraContext(@Nonnull Map<String, String> var1);

        @Nonnull
        public Builder withExtraContext(@Nonnull Set<Map.Entry<String, String>> var1);

        @Nonnull
        public Builder withExtraContext(@Nonnull Map.Entry<String, String> var1);

        @Nonnull
        public Builder withExtraContext(@Nonnull ContextSet var1);

        @Nonnull
        public Builder setExtraContext(@Nonnull ContextSet var1);

        @Nonnull
        public Node build();
    }
}

