/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.caching;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.metastacking.MetaStackDefinition;

public final class MetaContexts {
    private final Contexts contexts;
    private final MetaStackDefinition prefixStackDefinition;
    private final MetaStackDefinition suffixStackDefinition;
    private final int hashCode;

    public static MetaContexts of(@Nonnull Contexts contexts, @Nonnull MetaStackDefinition prefixStackDefinition, @Nonnull MetaStackDefinition suffixStackDefinition) {
        return new MetaContexts(contexts, prefixStackDefinition, suffixStackDefinition);
    }

    public MetaContexts(@Nonnull Contexts contexts, @Nonnull MetaStackDefinition prefixStackDefinition, @Nonnull MetaStackDefinition suffixStackDefinition) {
        this.contexts = (Contexts)Preconditions.checkNotNull((Object)contexts, (Object)"contexts");
        this.prefixStackDefinition = (MetaStackDefinition)Preconditions.checkNotNull((Object)prefixStackDefinition, (Object)"prefixStackDefinition");
        this.suffixStackDefinition = (MetaStackDefinition)Preconditions.checkNotNull((Object)suffixStackDefinition, (Object)"suffixStackDefinition");
        this.hashCode = this.calculateHashCode();
    }

    @Nonnull
    public Contexts getContexts() {
        return this.contexts;
    }

    @Nonnull
    public MetaStackDefinition getPrefixStackDefinition() {
        return this.prefixStackDefinition;
    }

    @Nonnull
    public MetaStackDefinition getSuffixStackDefinition() {
        return this.suffixStackDefinition;
    }

    @Nonnull
    public String toString() {
        return "MetaContexts(contexts=" + this.getContexts() + ", prefixStackDefinition=" + this.getPrefixStackDefinition() + ", suffixStackDefinition=" + this.getSuffixStackDefinition() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaContexts)) {
            return false;
        }
        MetaContexts other = (MetaContexts)o;
        return this.getContexts().equals(other.getContexts()) && this.getPrefixStackDefinition().equals(other.getPrefixStackDefinition()) && this.getSuffixStackDefinition().equals(other.getSuffixStackDefinition());
    }

    private int calculateHashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContexts().hashCode();
        result = result * 59 + this.getPrefixStackDefinition().hashCode();
        result = result * 59 + this.getSuffixStackDefinition().hashCode();
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

