/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.inventory.ChatInputAction;
import me.wolfyscript.utilities.api.inventory.GuiUpdateEvent;
import me.wolfyscript.utilities.api.inventory.GuiWindow;
import me.wolfyscript.utilities.api.inventory.InventoryAPI;
import me.wolfyscript.utilities.api.inventory.button.Button;
import me.wolfyscript.utilities.api.inventory.cache.CustomCache;
import me.wolfyscript.utilities.api.inventory.events.GuiCloseEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;

public class GuiHandler<T extends CustomCache>
implements Listener {
    private WolfyUtilities api;
    private InventoryAPI invAPI;
    private Player player;
    private boolean changingInv = false;
    private ChatInputAction chatInputAction = null;
    private HashMap<String, List<String>> clusterHistory = new HashMap();
    private String currentGuiCluster = "";
    private boolean isWindowOpen = false;
    private boolean helpEnabled = false;
    private T customCache;

    public GuiHandler(Player player, WolfyUtilities api, T customCache) {
        this.api = api;
        this.invAPI = api.getInventoryAPI();
        this.player = player;
        this.customCache = customCache;
        Bukkit.getPluginManager().registerEvents((Listener)this, api.getPlugin());
    }

    public boolean isChangingInv() {
        return this.changingInv;
    }

    public WolfyUtilities getApi() {
        return this.api;
    }

    @Nullable
    public Player getPlayer() {
        return this.player.getPlayer();
    }

    public boolean hasPlayer() {
        return this.getPlayer() != null;
    }

    public String getCurrentGuiCluster() {
        return this.currentGuiCluster;
    }

    public void setCurrentGuiCluster(String currentGuiCluster) {
        this.currentGuiCluster = currentGuiCluster;
    }

    public boolean isWindowOpen() {
        return this.isWindowOpen;
    }

    public boolean verifyInventory(Inventory inventory) {
        return this.isWindowOpen() && this.getCurrentInv() != null && this.getCurrentInv().getInventory(this).equals(inventory);
    }

    public void reloadInv(String clusterID, String guiWindowID) {
        List history = this.clusterHistory.getOrDefault(clusterID, new ArrayList());
        history.remove(history.get(history.size() - 1));
        this.clusterHistory.put(clusterID, history);
        this.changeToInv(clusterID, guiWindowID);
    }

    @Nullable
    public GuiWindow getCurrentInv(String clusterID) {
        if (this.clusterHistory.get(clusterID) != null && this.clusterHistory.get(clusterID).size() > 0) {
            return this.invAPI.getGuiWindow(clusterID, this.clusterHistory.get(clusterID).get(this.clusterHistory.get(clusterID).size() - 1));
        }
        return null;
    }

    @Nullable
    public GuiWindow getCurrentInv() {
        return this.getCurrentInv(this.getCurrentGuiCluster());
    }

    @Nullable
    public GuiWindow getPreviousInv(String clusterID) {
        return this.getPreviousInv(clusterID, 2);
    }

    @Nullable
    public GuiWindow getPreviousInv(String clusterID, int stepsBack) {
        if (this.clusterHistory.get(clusterID) != null && this.clusterHistory.get(clusterID).size() > stepsBack) {
            return this.invAPI.getGuiWindow(clusterID, this.clusterHistory.get(clusterID).get(this.clusterHistory.get(clusterID).size() - (stepsBack + 1)));
        }
        return null;
    }

    public GuiWindow getPreviousInv() {
        return this.getPreviousInv(this.getCurrentGuiCluster());
    }

    public GuiWindow getPreviousInv(int stepsBack) {
        return this.getPreviousInv(this.getCurrentGuiCluster(), stepsBack);
    }

    public void openPreviousInv() {
        this.openPreviousInv(this.getCurrentGuiCluster());
    }

    public void openPreviousInv(String clusterID) {
        this.openPreviousInv(clusterID, 1);
    }

    public void openPreviousInv(int stepsBack) {
        this.openPreviousInv(this.getCurrentGuiCluster(), stepsBack);
    }

    public void openPreviousInv(String clusterID, int stepsBack) {
        String previousInv = this.getPreviousInv(stepsBack).getNamespace();
        List history = this.clusterHistory.getOrDefault(clusterID, new ArrayList());
        for (int i = 0; i < stepsBack; ++i) {
            history.remove(history.size() - 1);
        }
        this.clusterHistory.put(clusterID, history);
        this.changeToInv(clusterID, previousInv);
    }

    public void changeToInv(String guiWindowID) {
        this.changeToInv(this.getCurrentGuiCluster(), guiWindowID);
    }

    public void changeToInv(@Nonnull String clusterID, @Nonnull String guiWindowID) {
        Bukkit.getScheduler().runTask(this.getApi().getPlugin(), () -> {
            Player player1 = this.getPlayer();
            this.changingInv = true;
            player1.closeInventory();
            if (WolfyUtilities.hasPermission((CommandSender)player1, this.getApi().getPlugin().getDescription().getName().toLowerCase(Locale.ROOT) + ".inv." + clusterID.toLowerCase(Locale.ROOT) + "." + guiWindowID.toLowerCase(Locale.ROOT))) {
                List history = this.clusterHistory.getOrDefault(clusterID, new ArrayList());
                if (this.getCurrentInv(clusterID) == null || !this.getCurrentInv(clusterID).getNamespace().equals(guiWindowID)) {
                    history.add(guiWindowID);
                }
                this.clusterHistory.put(clusterID, history);
                if (this.api.getInventoryAPI().getGuiWindow(clusterID, guiWindowID) != null) {
                    this.currentGuiCluster = clusterID;
                    this.isWindowOpen = true;
                    GuiWindow guiWindow = this.api.getInventoryAPI().getGuiWindow(clusterID, guiWindowID);
                    GuiUpdateEvent event = new GuiUpdateEvent(this, guiWindow);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    this.api.getInventoryAPI().getGuiWindow(clusterID, guiWindowID).setCachedInventorie(this, event.getInventory());
                    player1.openInventory(event.getInventory());
                }
            } else {
                this.api.sendPlayerMessage(player1, "\u00a74You don't have the permission \u00a7c" + this.getApi().getPlugin().getDescription().getName().toLowerCase() + ".inv." + clusterID.toLowerCase(Locale.ROOT) + "." + guiWindowID.toLowerCase(Locale.ROOT));
            }
            this.changingInv = false;
        });
    }

    public void openCluster() {
        this.openCluster(this.getCurrentGuiCluster());
    }

    public void openCluster(String clusterID) {
        String guiWindowID = this.invAPI.getGuiCluster(clusterID).getMainMenu();
        if (this.getCurrentInv(clusterID) != null) {
            guiWindowID = this.getCurrentInv(clusterID).getNamespace();
        }
        this.changeToInv(clusterID, guiWindowID);
    }

    public boolean isChatEventActive() {
        return this.getChatInputAction() != null;
    }

    public ChatInputAction getChatInputAction() {
        return this.chatInputAction;
    }

    public void setChatInputAction(ChatInputAction chatInputAction) {
        this.chatInputAction = chatInputAction;
    }

    public void close() {
        this.isWindowOpen = false;
        this.player.closeInventory();
    }

    public void setHelpEnabled(boolean helpEnabled) {
        this.helpEnabled = helpEnabled;
    }

    public boolean isHelpEnabled() {
        return this.helpEnabled;
    }

    public void setButton(GuiWindow guiWindow, int slot, String id) {
        TreeMap<Integer, String> buttons = ((CustomCache)this.customCache).getButtons(guiWindow);
        buttons.put(slot, id);
        ((CustomCache)this.customCache).setButtons(guiWindow, buttons);
    }

    public Button getButton(GuiWindow guiWindow, int slot) {
        String id = ((CustomCache)this.customCache).getButtons(guiWindow).get(slot);
        if (id != null && !id.isEmpty() && id.contains(":")) {
            return this.api.getInventoryAPI().getButton(id.split(":")[0], id.split(":")[1]);
        }
        return guiWindow.getButton(id);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onClose(InventoryCloseEvent event) {
        Player eventPlayer = (Player)event.getPlayer();
        if (this.player.equals(eventPlayer) && !this.clusterHistory.isEmpty() && this.isWindowOpen() && !this.changingInv) {
            String cluster = this.getCurrentGuiCluster();
            GuiWindow guiWindow = this.getCurrentInv();
            GuiCloseEvent closeEvent = new GuiCloseEvent(cluster, guiWindow, this, event.getView());
            Bukkit.getPluginManager().callEvent((Event)closeEvent);
            if (closeEvent.isCancelled()) {
                Bukkit.getScheduler().runTask(this.getApi().getPlugin(), this::openCluster);
            } else {
                this.isWindowOpen = false;
            }
        }
    }

    public void cancelChatEvent() {
        this.setChatInputAction(null);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.getUniqueId().equals(this.player.getUniqueId())) {
            this.player = player;
        }
    }

    public T getCustomCache() {
        return this.customCache;
    }
}

