/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.inventory.button;

import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.inventory.GuiWindow;
import me.wolfyscript.utilities.api.inventory.button.ButtonAction;
import me.wolfyscript.utilities.api.inventory.button.ButtonActionRender;
import me.wolfyscript.utilities.api.inventory.button.ButtonRender;
import me.wolfyscript.utilities.api.utils.ItemUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ButtonState {
    private String clusterID;
    private String key;
    private final ItemStack presetIcon;
    private ItemStack[] icon;
    private ButtonAction action;
    private ButtonRender buttonRender = null;
    private String displayName;
    private String[] helpLore;
    private String[] normalLore;

    public ButtonState(String key, ItemStack presetIcon, ButtonAction action) {
        this.key = key;
        this.presetIcon = presetIcon;
        this.action = action;
    }

    public ButtonState(String key, ItemStack presetIcon, ButtonActionRender action) {
        this.key = key;
        this.presetIcon = presetIcon;
        this.action = action;
    }

    public ButtonState(String key, ItemStack presetIcon, int customModelData, ButtonAction action) {
        this.key = key;
        this.presetIcon = presetIcon;
        if (WolfyUtilities.hasVillagePillageUpdate()) {
            ItemMeta itemMeta = this.presetIcon.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(customModelData));
            this.presetIcon.setItemMeta(itemMeta);
        }
        this.action = action;
    }

    public ButtonState(String key, ItemStack presetIcon, int customModelData, ButtonActionRender action) {
        this.key = key;
        this.presetIcon = presetIcon;
        if (WolfyUtilities.hasVillagePillageUpdate()) {
            ItemMeta itemMeta = this.presetIcon.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(customModelData));
            this.presetIcon.setItemMeta(itemMeta);
        }
        this.action = action;
    }

    public ButtonState(String key, Material presetIcon, ButtonAction action) {
        this(key, new ItemStack(presetIcon), action);
    }

    public ButtonState(String key, Material presetIcon, ButtonActionRender action) {
        this(key, new ItemStack(presetIcon), action);
    }

    public ButtonState(String key, Material presetIcon, int customModelData, ButtonAction action) {
        this(key, new ItemStack(presetIcon), customModelData, action);
    }

    public ButtonState(String key, Material presetIcon, int customModelData, ButtonActionRender action) {
        this(key, new ItemStack(presetIcon), customModelData, action);
    }

    public ButtonState(String key, ItemStack presetIcon) {
        this(key, presetIcon, null);
    }

    public ButtonState(String key, Material presetIcon) {
        this(key, new ItemStack(presetIcon), null);
    }

    public ButtonState(String key, ItemStack presetIcon, ButtonRender render) {
        this(key, presetIcon, null);
        this.setRenderAction(render);
    }

    public ButtonState(String key, Material presetIcon, ButtonRender render) {
        this(key, new ItemStack(presetIcon), null);
        this.setRenderAction(render);
    }

    public ButtonState(String clusterID, String key, ItemStack presetIcon, ButtonAction action) {
        this.action = action;
        this.presetIcon = presetIcon;
        this.clusterID = clusterID;
        this.key = key;
    }

    public ButtonState(String clusterID, String key, ItemStack presetIcon, int customModelData, ButtonAction action) {
        this.action = action;
        this.presetIcon = presetIcon;
        if (WolfyUtilities.hasVillagePillageUpdate()) {
            ItemMeta itemMeta = this.presetIcon.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(customModelData));
            this.presetIcon.setItemMeta(itemMeta);
        }
        this.clusterID = clusterID;
        this.key = key;
    }

    public ButtonState(String clusterID, String key, Material presetIcon, ButtonAction action) {
        this(clusterID, key, new ItemStack(presetIcon), action);
    }

    public ButtonState(String clusterID, String key, Material presetIcon, int customModelData, ButtonAction action) {
        this(clusterID, key, new ItemStack(presetIcon), customModelData, action);
    }

    public ButtonState(ItemStack presetIcon, String displayName, String[] helpLore, String[] normalLore, ButtonAction action) {
        this.action = action;
        this.presetIcon = presetIcon;
        this.icon = ItemUtils.createItem(presetIcon, displayName, helpLore, normalLore);
    }

    public ButtonState(Material presetIcon, String displayName, String[] helpLore, String[] normalLore, ButtonAction action) {
        this(new ItemStack(presetIcon), displayName, helpLore, normalLore, action);
    }

    public void init(GuiWindow window) {
        if (this.key != null && !this.key.isEmpty()) {
            String path = "inventories." + window.getClusterID() + "." + window.getNamespace() + ".items." + this.key;
            if (this.clusterID != null && !this.clusterID.isEmpty()) {
                path = "inventories." + this.clusterID + ".global_items." + this.key;
            }
            this.displayName = window.getAPI().getLanguageAPI().getActiveLanguage().replaceKeys("$" + path + ".name$");
            this.helpLore = window.getAPI().getLanguageAPI().getActiveLanguage().getConfig().get(path + ".help") != null ? window.getAPI().getLanguageAPI().getActiveLanguage().replaceKey(path + ".help").toArray(new String[0]) : new String[]{};
            this.normalLore = window.getAPI().getLanguageAPI().getActiveLanguage().getConfig().get(path + ".lore") != null ? window.getAPI().getLanguageAPI().getActiveLanguage().replaceKey(path + ".lore").toArray(new String[0]) : new String[]{};
            this.icon = ItemUtils.createItem(this.presetIcon, this.displayName, this.helpLore, this.normalLore);
        }
    }

    public void init(String clusterID, WolfyUtilities api) {
        if (this.key != null && !this.key.isEmpty()) {
            String path = "inventories." + clusterID + ".global_items." + this.key;
            this.displayName = api.getLanguageAPI().getActiveLanguage().replaceKeys("$" + path + ".name$");
            this.helpLore = api.getLanguageAPI().getActiveLanguage().getConfig().get(path + ".help") != null ? api.getLanguageAPI().getActiveLanguage().replaceKey(path + ".help").toArray(new String[0]) : new String[]{};
            this.normalLore = api.getLanguageAPI().getActiveLanguage().getConfig().get(path + ".lore") != null ? api.getLanguageAPI().getActiveLanguage().replaceKey(path + ".lore").toArray(new String[0]) : new String[]{};
        }
        this.icon = ItemUtils.createItem(this.presetIcon, this.displayName, this.helpLore, this.normalLore);
    }

    public ItemStack getIcon(boolean help) {
        if (help) {
            return this.icon[1].clone();
        }
        return this.icon[0].clone();
    }

    public ButtonAction getAction() {
        return this.action;
    }

    public ButtonState setAction(ButtonAction action) {
        this.action = action;
        return this;
    }

    public ButtonState setRenderAction(ButtonRender renderAction) {
        this.buttonRender = renderAction;
        return this;
    }

    public static ItemStack createItem() {
        return null;
    }

    public ButtonRender getRenderAction() {
        return this.buttonRender;
    }
}

