/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.utils;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryUtils {
    public static boolean isEmpty(List<ItemStack> list) {
        for (ItemStack itemStack : list) {
            if (itemStack.getType().equals((Object)Material.AIR)) continue;
            return false;
        }
        return true;
    }

    public static int getInventorySpace(Player p, ItemStack item) {
        return InventoryUtils.getInventorySpace((Inventory)p.getInventory(), item);
    }

    public static int getInventorySpace(Inventory inventory, ItemStack item) {
        int free = 0;
        for (ItemStack i : inventory.getStorageContents()) {
            if (i == null || i.getType().equals((Object)Material.AIR)) {
                free += item.getMaxStackSize();
                continue;
            }
            if (!i.isSimilar(item)) continue;
            free += item.getMaxStackSize() - i.getAmount();
        }
        return free;
    }

    public static boolean hasInventorySpace(Inventory inventory, ItemStack itemStack) {
        return InventoryUtils.getInventorySpace(inventory, itemStack) >= itemStack.getAmount();
    }

    public static boolean hasInventorySpace(Player p, ItemStack item) {
        return InventoryUtils.getInventorySpace(p, item) >= item.getAmount();
    }

    public static boolean hasEmptySpaces(Player p, int count) {
        int empty = 0;
        for (ItemStack i : p.getInventory()) {
            if (i != null) continue;
            ++empty;
        }
        return empty >= count;
    }

    public static int firstSimilar(Inventory inventory, ItemStack itemStack) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack slotItem = inventory.getItem(i);
            if (slotItem == null) {
                return i;
            }
            if (!slotItem.isSimilar(itemStack) && !itemStack.isSimilar(slotItem) || slotItem.getAmount() + itemStack.getAmount() > slotItem.getMaxStackSize()) continue;
            return i;
        }
        return -1;
    }
}

