/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.wolfyscript.utilities.api.utils.Reflection;
import me.wolfyscript.utilities.main.Main;
import org.bukkit.Material;

public enum ItemCategory {
    BREWING,
    BUILDING_BLOCKS,
    DECORATIONS,
    COMBAT,
    TOOLS,
    REDSTONE,
    FOOD,
    TRANSPORTATION,
    MISC,
    SEARCH;

    private static HashMap<String, List<Material>> materials;

    public static void init() throws NoSuchMethodException {
        Main.getMainUtil().sendConsoleMessage("Loading Item Categories...");
        Class<?> craftMagicNumbersClass = Reflection.getOBC("util.CraftMagicNumbers");
        Class<?> creativeModeTabClass = Reflection.getNMS("CreativeModeTab");
        Class<?> itemClass = Reflection.getNMS("Item");
        Method getItem = craftMagicNumbersClass.getMethod("getItem", Material.class);
        Field getCreativeModeTab = Reflection.findField(itemClass, creativeModeTabClass);
        getCreativeModeTab.setAccessible(true);
        Method creativeModeToString = creativeModeTabClass.getMethod("c", new Class[0]);
        if (getItem != null && creativeModeToString != null) {
            try {
                for (Material material : Material.values()) {
                    Object creativeModeTabObj;
                    Object itemObj = getItem.invoke(craftMagicNumbersClass, material);
                    if (itemObj == null || (creativeModeTabObj = getCreativeModeTab.get(itemObj)) == null) continue;
                    String name = (String)creativeModeToString.invoke(creativeModeTabObj, new Object[0]);
                    List category = materials.getOrDefault(name, new ArrayList());
                    category.add(material);
                    materials.put(name, category);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isValid(Material material) {
        List<Material> category = materials.get(this.toString().toLowerCase(Locale.ROOT));
        if (category == null) {
            Main.getMainUtil().sendConsoleWarning("Invalid category: " + this.toString().toLowerCase(Locale.ROOT));
        }
        return category.contains(material);
    }

    public static boolean isValid(Material material, ItemCategory itemCategory) {
        List<Material> category = materials.get(itemCategory.toString().toLowerCase(Locale.ROOT));
        if (category != null) {
            return category.contains(material);
        }
        return false;
    }

    public static ItemCategory getCategory(Material material) {
        for (Map.Entry<String, List<Material>> entry : materials.entrySet()) {
            if (!entry.getValue().contains(material)) continue;
            return ItemCategory.valueOf(entry.getKey());
        }
        return SEARCH;
    }

    public static HashMap<String, List<Material>> getMaterials() {
        return materials;
    }

    static {
        materials = new HashMap();
    }
}

