/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import me.wolfyscript.utilities.api.config.Config;
import me.wolfyscript.utilities.api.config.ConfigAPI;
import me.wolfyscript.utilities.api.custom_items.CustomItems;
import me.wolfyscript.utilities.api.inventory.InventoryAPI;
import me.wolfyscript.utilities.api.inventory.cache.CustomCache;
import me.wolfyscript.utilities.api.language.LanguageAPI;
import me.wolfyscript.utilities.api.utils.Reflection;
import me.wolfyscript.utilities.api.utils.chat.ChatEvent;
import me.wolfyscript.utilities.api.utils.chat.ClickData;
import me.wolfyscript.utilities.api.utils.chat.ClickEvent;
import me.wolfyscript.utilities.api.utils.chat.HoverEvent;
import me.wolfyscript.utilities.api.utils.chat.PlayerAction;
import me.wolfyscript.utilities.api.utils.exceptions.InvalidCacheTypeException;
import me.wolfyscript.utilities.api.utils.particles.ParticleEffects;
import me.wolfyscript.utilities.api.utils.particles.Particles;
import me.wolfyscript.utilities.main.Main;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class WolfyUtilities
implements Listener {
    private static HashMap<Plugin, WolfyUtilities> wolfyUtilitiesList = new HashMap();
    private static CustomItems customItems;
    private static Particles particles;
    private static ParticleEffects particleEffects;
    static Random random;
    private static HashMap<UUID, PlayerAction> clickDataMap;
    private static HashMap<String, Boolean> classes;
    private Plugin plugin;
    private String CONSOLE_PREFIX;
    private String CHAT_PREFIX;
    private String dataBasePrefix;
    private ConfigAPI configAPI;
    private InventoryAPI inventoryAPI;
    private LanguageAPI languageAPI;

    public static CustomItems getCustomItems() {
        return customItems;
    }

    public static void registerAPI(WolfyUtilities wolfyUtilities) {
        if (!WolfyUtilities.hasAPI(wolfyUtilities.getPlugin())) {
            wolfyUtilitiesList.put(wolfyUtilities.getPlugin(), wolfyUtilities);
        }
    }

    public static boolean hasAPI(Plugin plugin) {
        return wolfyUtilitiesList.containsKey(plugin);
    }

    public static WolfyUtilities getOrCreateAPI(Plugin plugin) {
        if (!WolfyUtilities.hasAPI(plugin)) {
            WolfyUtilities.registerAPI(new WolfyUtilities(plugin));
        }
        return wolfyUtilitiesList.get(plugin);
    }

    public static boolean hasBuzzyBeesUpdate() {
        return WolfyUtilities.hasSpecificUpdate(115);
    }

    public static boolean hasVillagePillageUpdate() {
        return WolfyUtilities.hasSpecificUpdate(114);
    }

    public static boolean hasAquaticUpdate() {
        return WolfyUtilities.hasSpecificUpdate(113);
    }

    public static boolean hasCombatUpdate() {
        return WolfyUtilities.hasSpecificUpdate(19);
    }

    public static boolean hasSpecificUpdate(String versionString) {
        return Main.getMcUpdateVersionNumber() >= Integer.parseInt(versionString.replace("_", "").replace(".", "").replace("-", ""));
    }

    public static boolean hasSpecificUpdate(int versionNumber) {
        return Main.getMcUpdateVersionNumber() >= versionNumber;
    }

    public static boolean hasSpigot() {
        return WolfyUtilities.hasClass("org.spigotmc.Metrics");
    }

    public static boolean hasWorldGuard() {
        return WolfyUtilities.hasClass("com.sk89q.worldguard.WorldGuard");
    }

    public static boolean hasPlotSquared() {
        return WolfyUtilities.hasClass("com.intellectualcrafters.plot.api.PlotAPI");
    }

    public static boolean hasLWC() {
        return WolfyUtilities.hasClass("com.griefcraft.lwc.LWC");
    }

    public static boolean hasMythicMobs() {
        return WolfyUtilities.hasClass("io.lumine.xikage.mythicmobs.MythicMobs");
    }

    public static boolean hasPlaceHolderAPI() {
        return Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    public static boolean hasClass(String path) {
        if (classes.containsKey(path)) {
            return classes.get(path);
        }
        try {
            Class.forName(path);
            classes.put(path, true);
            return true;
        }
        catch (Exception e) {
            classes.put(path, false);
            return false;
        }
    }

    public static boolean hasPermission(CommandSender sender, String permCode) {
        List<String> permissions = Arrays.asList(permCode.split("\\."));
        StringBuilder permission = new StringBuilder();
        if (sender.hasPermission("*")) {
            return true;
        }
        for (String perm : permissions) {
            permission.append(perm);
            if (permissions.indexOf(perm) < permissions.size() - 1) {
                permission.append(".*");
            }
            if (sender.hasPermission(permission.toString())) {
                return true;
            }
            permission.replace(permission.length() - 2, permission.length(), "");
            permission.append(".");
        }
        return false;
    }

    public static void sendParticles(Player player, String particle, boolean biggerRadius, float x, float y, float z, float xOffset, float yOffset, float zOffset, int count, float particledata, int ... data) {
        try {
            Object enumParticles = Reflection.getNMS("EnumParticle").getField(particle).get(null);
            Constructor<?> particleConstructor = Reflection.getNMS("PacketPlayOutWorldParticles").getConstructor(Reflection.getNMS("EnumParticle"), Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, int[].class);
            Object packet = particleConstructor.newInstance(enumParticles, biggerRadius, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z), Float.valueOf(xOffset), Float.valueOf(yOffset), Float.valueOf(zOffset), Float.valueOf(particledata), count, data);
            WolfyUtilities.sendPacket(player, packet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void sendPacket(Player player, Object packet) {
        try {
            Object handle = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            Object playerConnection = handle.getClass().getField("playerConnection").get(handle);
            playerConnection.getClass().getMethod("sendPacket", Reflection.getNMS("Packet")).invoke(playerConnection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getCode() {
        Random random = new Random();
        String alphabet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int x = alphabet.length();
        StringBuilder sB = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            sB.append(alphabet.charAt(random.nextInt(x)));
        }
        return sB.toString();
    }

    public static ItemStack getCustomHead(String value) {
        if (value.startsWith("http://textures")) {
            value = WolfyUtilities.getBase64EncodedString(String.format("{textures:{SKIN:{url:\"%s\"}}}", value));
        }
        return WolfyUtilities.getSkullByValue(value);
    }

    public static ItemStack getSkullViaURL(String value) {
        return WolfyUtilities.getCustomHead("http://textures.minecraft.net/texture/" + value);
    }

    public static ItemStack getSkullByValue(String value) {
        ItemStack itemStack = WolfyUtilities.hasAquaticUpdate() ? new ItemStack(Material.PLAYER_HEAD) : new ItemStack(Material.PLAYER_HEAD, 1, 0, Byte.valueOf((byte)3));
        if (value != null && !value.isEmpty()) {
            SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
            GameProfile profile = new GameProfile(UUID.randomUUID(), null);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", value));
            Field profileField = null;
            try {
                profileField = skullMeta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            try {
                profileField.set(skullMeta, profile);
                itemStack.setItemMeta((ItemMeta)skullMeta);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return itemStack;
    }

    public static SkullMeta getSkullmeta(String value, SkullMeta skullMeta) {
        if (value != null && !value.isEmpty()) {
            String texture = value;
            if (value.startsWith("https://") || value.startsWith("http://")) {
                texture = WolfyUtilities.getBase64EncodedString(String.format("{textures:{SKIN:{url:\"%s\"}}}", value));
            }
            GameProfile profile = new GameProfile(UUID.randomUUID(), null);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
            Field profileField = null;
            try {
                profileField = skullMeta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            try {
                profileField.set(skullMeta, profile);
                return skullMeta;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return skullMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBase64EncodedString(String str) {
        String var3;
        ByteBuf byteBuf = null;
        ByteBuf encodedByteBuf = null;
        try {
            byteBuf = Unpooled.wrappedBuffer((byte[])str.getBytes(StandardCharsets.UTF_8));
            encodedByteBuf = Base64.encode((ByteBuf)byteBuf);
            var3 = encodedByteBuf.toString(StandardCharsets.UTF_8);
        }
        finally {
            if (byteBuf != null) {
                byteBuf.release();
                if (encodedByteBuf != null) {
                    encodedByteBuf.release();
                }
            }
        }
        return var3;
    }

    public static String getSkullValue(SkullMeta skullMeta) {
        GameProfile profile = null;
        try {
            Field profileField = skullMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            try {
                profile = (GameProfile)profileField.get(skullMeta);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        catch (NoSuchFieldException | SecurityException ex) {
            ex.printStackTrace();
        }
        if (profile != null && !profile.getProperties().get((Object)"textures").isEmpty()) {
            for (Property property : profile.getProperties().get((Object)"textures")) {
                if (property.getValue().isEmpty()) continue;
                return property.getValue();
            }
        }
        return null;
    }

    public static ItemStack migrateSkullTexture(ItemStack input, ItemStack result) {
        SkullMeta inputMeta;
        String value;
        if (input.getType().equals((Object)Material.PLAYER_HEAD) && result.getType().equals((Object)Material.PLAYER_HEAD) && (value = WolfyUtilities.getSkullValue(inputMeta = (SkullMeta)input.getItemMeta())) != null && !value.isEmpty()) {
            result.setItemMeta((ItemMeta)WolfyUtilities.getSkullmeta(value, (SkullMeta)result.getItemMeta()));
        }
        return result;
    }

    public static ItemMeta migrateSkullTexture(SkullMeta input, ItemStack result) {
        String value;
        if (result.getType().equals((Object)Material.PLAYER_HEAD) && (value = WolfyUtilities.getSkullValue(input)) != null && !value.isEmpty()) {
            return WolfyUtilities.getSkullmeta(value, (SkullMeta)result.getItemMeta());
        }
        return result.getItemMeta();
    }

    public static String hideString(String hide) {
        char[] data = new char[hide.length() * 2];
        for (int i = 0; i < data.length; i += 2) {
            data[i] = 167;
            data[i + 1] = hide.charAt(i == 0 ? 0 : i / 2);
        }
        return new String(data);
    }

    public static String unhideString(String unhide) {
        return unhide.replace("\u00a7", "");
    }

    public static String translateColorCodes(String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != '&') continue;
            if (b[i + 1] == '&') {
                b[i + 1] = 61;
                continue;
            }
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b).replace("&=", "&");
    }

    public static Enchantment getEnchantment(String enchantNmn) {
        try {
            return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantNmn.toLowerCase()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Sound getSound(String sound) {
        return Sound.valueOf((String)sound);
    }

    @Deprecated
    public static Sound getSound(String legacy, String notLegacy) {
        if (WolfyUtilities.hasAquaticUpdate()) {
            return Sound.valueOf((String)notLegacy);
        }
        return Sound.valueOf((String)legacy);
    }

    @Deprecated
    public static boolean isSkull(ItemStack itemStack) {
        return itemStack.getType() == Material.PLAYER_HEAD;
    }

    public static boolean isPlayerHead(ItemStack itemStack) {
        return itemStack.getType() == Material.PLAYER_HEAD;
    }

    public static boolean checkColumn(ArrayList<String> shape, int column) {
        boolean blocked = false;
        for (String s : shape) {
            if (s.charAt(column) == ' ') continue;
            blocked = true;
        }
        if (!blocked) {
            for (int i = 0; i < shape.size(); ++i) {
                shape.set(i, shape.get(i).substring(0, column) + shape.get(i).substring(column + 1));
            }
        }
        return blocked;
    }

    public static ArrayList<String> formatShape(String ... shape) {
        String row;
        ArrayList<String> cleared = new ArrayList<String>(Arrays.asList(shape));
        ListIterator<String> rowIterator = cleared.listIterator();
        boolean rowBlocked = false;
        while (!rowBlocked && rowIterator.hasNext()) {
            row = rowIterator.next();
            if (StringUtils.isBlank((String)row)) {
                rowIterator.remove();
                continue;
            }
            rowBlocked = true;
        }
        while (rowIterator.hasNext()) {
            rowIterator.next();
        }
        rowBlocked = false;
        while (!rowBlocked && rowIterator.hasPrevious()) {
            row = rowIterator.previous();
            if (StringUtils.isBlank((String)row)) {
                rowIterator.remove();
                continue;
            }
            rowBlocked = true;
        }
        if (!cleared.isEmpty()) {
            boolean columnBlocked = false;
            while (!columnBlocked) {
                if (!WolfyUtilities.checkColumn(cleared, 0)) continue;
                columnBlocked = true;
            }
            columnBlocked = false;
            int column = cleared.get(0).length() - 1;
            while (!columnBlocked) {
                if (WolfyUtilities.checkColumn(cleared, column)) {
                    columnBlocked = true;
                    continue;
                }
                --column;
            }
        }
        return cleared;
    }

    @Nullable
    public static WolfyUtilities getAPI(Plugin plugin) {
        return wolfyUtilitiesList.get(plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void actionCommands(AsyncPlayerChatEvent event) {
        if (event.getMessage() != null && event.getMessage().startsWith("wu::")) {
            UUID uuid;
            try {
                uuid = UUID.fromString(event.getMessage().substring("wu::".length()));
            }
            catch (IllegalArgumentException expected) {
                return;
            }
            PlayerAction action = clickDataMap.get(uuid);
            Player player = event.getPlayer();
            event.setMessage("");
            event.setCancelled(true);
            if (action != null) {
                if (player.getUniqueId().equals(action.getUuid())) {
                    action.run(player);
                    if (action.isDiscard()) {
                        clickDataMap.remove(uuid);
                    }
                }
            } else {
                this.sendDebugMessage(player.getName() + "&c tried to use a invalid action!");
            }
        }
    }

    @EventHandler
    public void actionRemoval(PlayerQuitEvent event) {
        clickDataMap.keySet().removeIf(uuid -> clickDataMap.get(uuid).getUuid().equals(event.getPlayer().getUniqueId()));
    }

    public WolfyUtilities(Plugin plugin) {
        this.plugin = plugin;
        this.dataBasePrefix = plugin.getName().toLowerCase(Locale.ROOT) + "_";
        WolfyUtilities.registerAPI(this);
        customItems = new CustomItems(plugin);
        this.inventoryAPI = new InventoryAPI<CustomCache>(this.plugin, this, CustomCache.class);
    }

    public static String getVersion() {
        return Main.getInstance().getDescription().getVersion();
    }

    public static int getVersionNumber() {
        return Integer.parseInt(WolfyUtilities.getVersion().replaceAll("[^0-9]", ""));
    }

    public LanguageAPI getLanguageAPI() {
        if (!this.hasLanguageAPI()) {
            this.languageAPI = new LanguageAPI(this.plugin);
        }
        return this.languageAPI;
    }

    public boolean isLanguageEnabled() {
        return this.languageAPI != null;
    }

    public ConfigAPI getConfigAPI() {
        if (!this.hasConfigAPI()) {
            this.configAPI = new ConfigAPI(this);
        }
        return this.configAPI;
    }

    public boolean isConfigEnabled() {
        return this.languageAPI != null;
    }

    public InventoryAPI getInventoryAPI() {
        return this.getInventoryAPI(this.inventoryAPI.craftCustomCache().getClass());
    }

    public <T extends CustomCache> InventoryAPI<T> getInventoryAPI(Class<T> type) {
        if (this.hasInventoryAPI() && type.isInstance(this.inventoryAPI.craftCustomCache())) {
            return this.inventoryAPI;
        }
        if (!this.hasInventoryAPI()) {
            this.inventoryAPI = new InventoryAPI<T>(this.plugin, this, type);
            return this.inventoryAPI;
        }
        throw new InvalidCacheTypeException("Cache type " + type.getName() + " expected, got " + this.inventoryAPI.craftCustomCache().getClass().getName() + "!");
    }

    public <T extends CustomCache> void setInventoryAPI(InventoryAPI<T> inventoryAPI) {
        this.inventoryAPI = inventoryAPI;
    }

    public boolean hasInventoryAPI() {
        return this.inventoryAPI != null;
    }

    public boolean hasLanguageAPI() {
        return this.languageAPI != null;
    }

    public boolean hasConfigAPI() {
        return this.configAPI != null;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void setCONSOLE_PREFIX(String CONSOLE_PREFIX) {
        this.CONSOLE_PREFIX = CONSOLE_PREFIX;
    }

    public void setCHAT_PREFIX(String CHAT_PREFIX) {
        this.CHAT_PREFIX = CHAT_PREFIX;
    }

    public String getCHAT_PREFIX() {
        return this.CHAT_PREFIX;
    }

    public String getCONSOLE_PREFIX() {
        return this.CONSOLE_PREFIX;
    }

    public String getDataBasePrefix() {
        return this.dataBasePrefix;
    }

    public void setDataBasePrefix(String dataBasePrefix) {
        this.dataBasePrefix = dataBasePrefix;
    }

    public boolean hasDebuggingMode() {
        if (this.getConfigAPI().getConfig("main_config") instanceof Config) {
            return ((Config)this.getConfigAPI().getConfig("main_config")).getBoolean("debug");
        }
        return false;
    }

    public void sendConsoleMessage(String message) {
        message = this.CONSOLE_PREFIX + this.getLanguageAPI().getActiveLanguage().replaceKeys(message);
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        Main.getInstance().getServer().getConsoleSender().sendMessage(message);
    }

    public void sendConsoleWarning(String message) {
        message = this.CONSOLE_PREFIX + "[WARN] " + this.getLanguageAPI().getActiveLanguage().replaceKeys(message);
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        Main.getInstance().getServer().getConsoleSender().sendMessage(message);
    }

    public void sendConsoleMessage(String message, String ... replacements) {
        message = this.CONSOLE_PREFIX + this.getLanguageAPI().getActiveLanguage().replaceKeys(message);
        ArrayList<String> keys = new ArrayList<String>();
        Pattern pattern = Pattern.compile("%([A-Z]*?)(_*?)%");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            keys.add(matcher.group(0));
        }
        for (int i = 0; i < keys.size(); ++i) {
            message = message.replace((CharSequence)keys.get(i), replacements[i]);
        }
        this.plugin.getServer().getConsoleSender().sendMessage(WolfyUtilities.translateColorCodes(message));
    }

    public void sendConsoleMessage(String message, String[] ... replacements) {
        if (replacements != null) {
            message = this.CHAT_PREFIX + this.getLanguageAPI().getActiveLanguage().replaceKeys(message);
            for (String[] replace : replacements) {
                if (replace.length <= 1) continue;
                message = message.replaceAll(replace[0], replace[1]);
            }
        }
        this.plugin.getServer().getConsoleSender().sendMessage(WolfyUtilities.translateColorCodes(message));
    }

    public void sendPlayerMessage(Player player, String message) {
        if (player != null) {
            message = this.CHAT_PREFIX + this.getLanguageAPI().getActiveLanguage().replaceKeys(message);
            message = WolfyUtilities.translateColorCodes(message);
            player.sendMessage(message);
        }
    }

    public void sendPlayerMessage(Player player, String guiCluster, String msgKey) {
        this.sendPlayerMessage(player, "$inventories." + guiCluster + ".global_messages." + msgKey + "$");
    }

    public void sendPlayerMessage(Player player, String guiCluster, String guiWindow, String msgKey) {
        this.sendPlayerMessage(player, "$inventories." + guiCluster + "." + guiWindow + ".messages." + msgKey + "$");
    }

    public void sendPlayerMessage(Player player, String guiCluster, String msgKey, String[] ... replacements) {
        String message = "$inventories." + guiCluster + ".global_messages." + msgKey + "$";
        this.sendPlayerMessage(player, message, replacements);
    }

    public void sendPlayerMessage(Player player, String guiCluster, String guiWindow, String msgKey, String[] ... replacements) {
        String message = "$inventories." + guiCluster + "." + guiWindow + ".messages." + msgKey + "$";
        this.sendPlayerMessage(player, message, replacements);
    }

    public void sendPlayerMessage(Player player, String message, String[] ... replacements) {
        if (replacements != null) {
            if (player != null) {
                message = this.CHAT_PREFIX + this.getLanguageAPI().getActiveLanguage().replaceKeys(message);
                for (String[] replace : replacements) {
                    if (replace.length <= 1) continue;
                    message = message.replaceAll(replace[0], replace[1]);
                }
            } else {
                return;
            }
        }
        player.sendMessage(WolfyUtilities.translateColorCodes(message));
    }

    public void sendActionMessage(Player player, ClickData ... clickData) {
        TextComponent[] textComponents = this.getActionMessage(this.CHAT_PREFIX, player, clickData);
        player.spigot().sendMessage((BaseComponent[])textComponents);
    }

    public void openBook(Player player, String author, String title, boolean editable, ClickData[] ... clickDatas) {
        ItemStack itemStack = new ItemStack(editable ? Material.BOOK : Material.WRITTEN_BOOK);
        BookMeta bookMeta = (BookMeta)itemStack.getItemMeta();
        bookMeta.setAuthor(author);
        bookMeta.setTitle(title);
        for (ClickData[] clickData : clickDatas) {
            TextComponent[] textComponents = this.getActionMessage("", player, clickData);
            bookMeta.spigot().addPage((BaseComponent[][])new BaseComponent[][]{textComponents});
        }
        itemStack.setItemMeta((ItemMeta)bookMeta);
        player.openBook(itemStack);
    }

    public void openBook(Player player, boolean editable, ClickData[] ... clickDatas) {
        this.openBook(player, "WolfyUtilities", "Blank", editable, clickDatas);
    }

    public TextComponent[] getActionMessage(String prefix, Player player, ClickData ... clickData) {
        TextComponent[] textComponents = new TextComponent[clickData.length + 1];
        textComponents[0] = new TextComponent(prefix);
        for (int i = 1; i < textComponents.length; ++i) {
            ClickData data = clickData[i - 1];
            TextComponent component = new TextComponent(this.getLanguageAPI().replaceColoredKeys(data.getMessage()));
            if (data.getClickAction() != null) {
                UUID id = UUID.randomUUID();
                while (clickDataMap.containsKey(id)) {
                    id = UUID.randomUUID();
                }
                PlayerAction playerAction = new PlayerAction(this, player, data);
                clickDataMap.put(id, playerAction);
                component.setClickEvent(new net.md_5.bungee.api.chat.ClickEvent(ClickEvent.Action.RUN_COMMAND, "wu::" + id.toString()));
            }
            for (ChatEvent chatEvent : data.getChatEvents()) {
                if (chatEvent instanceof HoverEvent) {
                    component.setHoverEvent(new net.md_5.bungee.api.chat.HoverEvent(((HoverEvent)chatEvent).getAction(), ((HoverEvent)chatEvent).getValue()));
                    continue;
                }
                if (!(chatEvent instanceof ClickEvent)) continue;
                component.setClickEvent(new net.md_5.bungee.api.chat.ClickEvent(((ClickEvent)chatEvent).getAction(), ((ClickEvent)chatEvent).getValue()));
            }
            textComponents[i] = component;
        }
        return textComponents;
    }

    public void sendDebugMessage(String message) {
        if (this.hasDebuggingMode()) {
            String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)"[&4CC&r] ");
            message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
            ArrayList<String> messages = new ArrayList<String>();
            if (message.length() > 70) {
                int count = message.length() / 70;
                for (int text = 0; text <= count; ++text) {
                    if (text < count) {
                        messages.add(message.substring(text * 70, 70 + 70 * text));
                        continue;
                    }
                    messages.add(message.substring(text * 70));
                }
                for (String result : messages) {
                    Main.getInstance().getServer().getConsoleSender().sendMessage(prefix + result);
                }
            } else {
                message = prefix + message;
                Main.getInstance().getServer().getConsoleSender().sendMessage(message);
            }
        }
    }

    static {
        random = new Random();
        clickDataMap = new HashMap();
        classes = new HashMap();
    }
}

