/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.wolfyscript.utilities.main.Main;
import org.bukkit.entity.Player;

public class Reflection {
    private static String versionString;
    private static Map<String, Class<?>> loadedNMSClasses;
    private static Map<String, Class<?>> loadedOBCClasses;
    private static Map<Class<?>, Map<String, Method>> loadedMethods;
    private static Map<Class<?>, Map<String, Field>> loadedFields;
    private static Map<Class<?>, Map<Class, Field>> foundFields;

    public static String getVersion() {
        return Main.getInstance().getServer().getClass().getPackage().getName().substring(23);
    }

    public static synchronized Class<?> getOBC(String obcClassName) {
        Class<?> clazz;
        if (loadedOBCClasses.containsKey(obcClassName)) {
            return loadedOBCClasses.get(obcClassName);
        }
        String clazzName = "org.bukkit.craftbukkit." + Reflection.getVersion() + "." + obcClassName;
        try {
            clazz = Class.forName(clazzName);
        }
        catch (Throwable t) {
            t.printStackTrace();
            loadedOBCClasses.put(obcClassName, null);
            return null;
        }
        loadedOBCClasses.put(obcClassName, clazz);
        return clazz;
    }

    public static Class<?> getNMS(String nmsClassName) {
        Class<?> clazz;
        if (loadedNMSClasses.containsKey(nmsClassName)) {
            return loadedNMSClasses.get(nmsClassName);
        }
        String clazzName = "net.minecraft.server." + Reflection.getVersion() + "." + nmsClassName;
        try {
            clazz = Class.forName(clazzName);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return loadedNMSClasses.put(nmsClassName, null);
        }
        loadedNMSClasses.put(nmsClassName, clazz);
        return clazz;
    }

    public static Object getConnection(Player player) {
        Method getHandleMethod = Reflection.getMethod(player.getClass(), "getHandle", new Class[0]);
        if (getHandleMethod != null) {
            try {
                Object nmsPlayer = getHandleMethod.invoke((Object)player, new Object[0]);
                Field playerConField = Reflection.getField(nmsPlayer.getClass(), "playerConnection");
                return playerConField.get(nmsPlayer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... params) {
        try {
            return clazz.getConstructor(params);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        Map<String, Method> methods;
        if (!loadedMethods.containsKey(clazz)) {
            loadedMethods.put(clazz, new HashMap());
        }
        if ((methods = loadedMethods.get(clazz)).containsKey(methodName)) {
            return methods.get(methodName);
        }
        try {
            Method method = clazz.getMethod(methodName, params);
            methods.put(methodName, method);
            loadedMethods.put(clazz, methods);
            return method;
        }
        catch (Exception e) {
            e.printStackTrace();
            methods.put(methodName, null);
            loadedMethods.put(clazz, methods);
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Map<String, Field> fields;
        if (!loadedFields.containsKey(clazz)) {
            loadedFields.put(clazz, new HashMap());
        }
        if ((fields = loadedFields.get(clazz)).containsKey(fieldName)) {
            return fields.get(fieldName);
        }
        try {
            Field field = clazz.getField(fieldName);
            fields.put(fieldName, field);
            loadedFields.put(clazz, fields);
            return field;
        }
        catch (Exception e) {
            e.printStackTrace();
            fields.put(fieldName, null);
            loadedFields.put(clazz, fields);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Field findField(Class<?> clazz, Class type) {
        Map<Class, Field> fields;
        if (!foundFields.containsKey(clazz)) {
            foundFields.put(clazz, new HashMap());
        }
        if ((fields = foundFields.get(clazz)).containsKey(type)) {
            return fields.get(type);
        }
        try {
            ArrayList<Field> allFields = new ArrayList<Field>();
            allFields.addAll(Arrays.asList(clazz.getFields()));
            allFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            for (Field f : allFields) {
                if (!type.equals(f.getType())) continue;
                fields.put(type, f);
                foundFields.put(clazz, fields);
                Field field = f;
                return field;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            fields.put(type, null);
            foundFields.put(clazz, fields);
        }
        return null;
    }

    static {
        loadedNMSClasses = new HashMap();
        loadedOBCClasses = new HashMap();
        loadedMethods = new HashMap();
        loadedFields = new HashMap();
        foundFields = new HashMap();
    }
}

