/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.config.Configuration;
import me.wolfyscript.utilities.api.config.FileConfiguration;
import me.wolfyscript.utilities.api.config.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigAPI {
    private Plugin plugin;
    private WolfyUtilities api;
    private boolean prettyPrinting = false;
    private HashMap<String, Configuration> configs;
    private int autoSave = -1;

    public ConfigAPI(WolfyUtilities api) {
        this.api = api;
        this.plugin = api.getPlugin();
        this.configs = new HashMap();
    }

    public ConfigAPI(WolfyUtilities api, boolean enableAutoSave, int intervalInMin) {
        this(api);
        this.setAutoSave(enableAutoSave, intervalInMin);
    }

    public void setAutoSave(boolean enabled, int intervalInMin) {
        if (this.autoSave == -1 && enabled) {
            this.runAutoSave(intervalInMin);
        } else if (!enabled) {
            this.stopAutoSave();
        } else {
            this.stopAutoSave();
            this.runAutoSave(intervalInMin);
        }
    }

    public void stopAutoSave() {
        if (this.plugin.getServer().getScheduler().isCurrentlyRunning(this.autoSave)) {
            this.plugin.getServer().getScheduler().cancelTask(this.autoSave);
        }
    }

    private void runAutoSave(int intervalInMin) {
        this.autoSave = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask(this.plugin, () -> {
            for (Configuration configuration : this.configs.values()) {
                if (!(configuration instanceof YamlConfiguration)) continue;
                ((YamlConfiguration)configuration).reloadAuto();
            }
        }, 1200L, (long)(intervalInMin * 60 * 20));
    }

    public void registerConfig(Configuration configuration) {
        this.configs.put(configuration.getName(), configuration);
    }

    public Configuration getConfig(String name) {
        return this.configs.get(name);
    }

    public YamlConfiguration getmainConfig() {
        if (this.getConfig("main_config") instanceof YamlConfiguration) {
            return (YamlConfiguration)this.getConfig("main_config");
        }
        return null;
    }

    public static void exportFile(Class reference, String resourcePath, String savePath) {
        InputStream ddlStream = reference.getClassLoader().getResourceAsStream(resourcePath);
        File target = new File(savePath);
        try {
            int r;
            target.createNewFile();
            FileOutputStream fos = new FileOutputStream(savePath);
            byte[] buf = new byte[2048];
            while ((r = ddlStream.read(buf)) != -1) {
                fos.write(buf, 0, r);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveConfigs() {
        for (Configuration configuration : this.configs.values()) {
            if (!(configuration instanceof FileConfiguration)) continue;
            ((FileConfiguration)configuration).save();
        }
    }

    public void loadConfigs() {
        for (Configuration configuration : this.configs.values()) {
            if (!(configuration instanceof FileConfiguration)) continue;
            ((FileConfiguration)configuration).load();
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public WolfyUtilities getApi() {
        return this.api;
    }

    public void setPrettyPrinting(boolean prettyPrinting) {
        this.prettyPrinting = prettyPrinting;
    }

    public boolean isPrettyPrinting() {
        return this.prettyPrinting;
    }
}

