/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.utils.Reflection;
import me.wolfyscript.utilities.main.Main;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ItemUtils {
    public static String convertItemStackToJson(ItemStack itemStack) {
        Object itemAsJsonObject;
        Class<?> craftItemStackClazz = Reflection.getOBC("inventory.CraftItemStack");
        Method asNMSCopyMethod = Reflection.getMethod(craftItemStackClazz, "asNMSCopy", ItemStack.class);
        Class<?> nmsItemStackClazz = Reflection.getNMS("ItemStack");
        Class<?> nbtTagCompoundClazz = Reflection.getNMS("NBTTagCompound");
        Method saveNmsItemStackMethod = Reflection.getMethod(nmsItemStackClazz, "save", nbtTagCompoundClazz);
        try {
            Object nmsNbtTagCompoundObj = nbtTagCompoundClazz.newInstance();
            Object nmsItemStackObj = asNMSCopyMethod.invoke(null, itemStack);
            itemAsJsonObject = saveNmsItemStackMethod.invoke(nmsItemStackObj, nmsNbtTagCompoundObj);
        }
        catch (Throwable t) {
            Main.getMainUtil().sendConsoleMessage("failed to serialize itemstack to nms item");
            Main.getMainUtil().sendConsoleMessage(t.toString());
            for (StackTraceElement element : t.getStackTrace()) {
                Main.getMainUtil().sendConsoleMessage(element.toString());
            }
            return null;
        }
        return itemAsJsonObject.toString();
    }

    public static ItemStack convertJsontoItemStack(String json) {
        Class<?> craftItemStackClazz = Reflection.getOBC("inventory.CraftItemStack");
        Class<?> nmsItemStackClazz = Reflection.getNMS("ItemStack");
        Class<?> nbtTagCompoundClazz = Reflection.getNMS("NBTTagCompound");
        Class<?> mojangParser = Reflection.getNMS("MojangsonParser");
        Method parseMethod = Reflection.getMethod(mojangParser, "parse", String.class);
        Method aMethod = Reflection.getMethod(nmsItemStackClazz, "a", nbtTagCompoundClazz);
        Method asBukkitCopyMethod = Reflection.getMethod(craftItemStackClazz, "asBukkitCopy", nmsItemStackClazz);
        try {
            Object nmsNbtTagCompoundObj = parseMethod.invoke(null, json);
            Object nmsItemStackObj = aMethod.invoke(null, nmsNbtTagCompoundObj);
            return (ItemStack)asBukkitCopyMethod.invoke(null, nmsItemStackObj);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ItemStack[] createItem(ItemStack itemStack, String displayName, String[] helpLore, String ... normalLore) {
        ItemStack[] itemStacks = new ItemStack[2];
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        if (itemMeta != null) {
            if (displayName != null && !displayName.isEmpty()) {
                itemMeta.setDisplayName(WolfyUtilities.translateColorCodes(displayName));
            }
            if (normalLore != null && normalLore.length > 0) {
                for (String row : normalLore) {
                    if (row.isEmpty()) continue;
                    lore.add(row.equalsIgnoreCase("<empty>") ? "" : ChatColor.translateAlternateColorCodes((char)'&', (String)row));
                }
            }
            if (lore.size() > 0) {
                itemMeta.setLore(lore);
            }
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
            itemStack.setItemMeta(itemMeta);
        }
        itemStacks[0] = itemStack;
        ItemStack helpItem = new ItemStack(itemStack);
        ItemMeta helpMeta = helpItem.getItemMeta();
        if (helpMeta != null) {
            if (helpLore != null && helpLore.length > 0) {
                for (String row : helpLore) {
                    if (row.isEmpty()) continue;
                    lore.add(row.equalsIgnoreCase("<empty>") ? "" : ChatColor.translateAlternateColorCodes((char)'&', (String)row));
                }
            }
            helpMeta.setLore(lore);
            helpItem.setItemMeta(helpMeta);
        }
        itemStacks[1] = helpItem;
        return itemStacks;
    }

    @Deprecated
    public static String serializeItemStack(ItemStack is) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream bukkitOutputStream = new BukkitObjectOutputStream((OutputStream)outputStream);
            bukkitOutputStream.writeObject((Object)is);
            bukkitOutputStream.flush();
            return Base64.getEncoder().encodeToString(outputStream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize ItemStack!", e);
        }
    }

    public static ItemStack deserializeItemStack(String data) {
        return ItemUtils.deserializeItemStack(Base64.getDecoder().decode(data));
    }

    public static ItemStack deserializeItemStack(byte[] bytes) {
        try {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                BukkitObjectInputStream bukkitInputStream = new BukkitObjectInputStream((InputStream)inputStream);
                Object itemStack = bukkitInputStream.readObject();
                if (itemStack instanceof ItemStack) {
                    return (ItemStack)itemStack;
                }
            }
            catch (StreamCorruptedException ex) {
                return ItemUtils.deserializeNMSItemStack(bytes);
            }
            return null;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String serializeNMSItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return "null";
        }
        ByteArrayOutputStream outputStream = null;
        try {
            Class<?> nbtTagCompoundClass = Reflection.getNMS("NBTTagCompound");
            Constructor<?> nbtTagCompoundConstructor = nbtTagCompoundClass.getConstructor(new Class[0]);
            Object nbtTagCompound = nbtTagCompoundConstructor.newInstance(new Object[0]);
            Object nmsItemStack = Reflection.getOBC("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class).invoke(null, itemStack);
            Reflection.getNMS("ItemStack").getMethod("save", nbtTagCompoundClass).invoke(nmsItemStack, nbtTagCompound);
            outputStream = new ByteArrayOutputStream();
            Reflection.getNMS("NBTCompressedStreamTools").getMethod("a", nbtTagCompoundClass, OutputStream.class).invoke(null, nbtTagCompound, outputStream);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return Base64.getEncoder().encodeToString(outputStream.toByteArray());
    }

    public static ItemStack deserializeNMSItemStack(String data) {
        return ItemUtils.deserializeNMSItemStack(Base64.getDecoder().decode(data));
    }

    public static ItemStack deserializeNMSItemStack(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        Class<?> nbtTagCompoundClass = Reflection.getNMS("NBTTagCompound");
        Class<?> nmsItemStackClass = Reflection.getNMS("ItemStack");
        ItemStack itemStack = null;
        try {
            Object nbtTagCompound = Reflection.getNMS("NBTCompressedStreamTools").getMethod("a", InputStream.class).invoke(null, inputStream);
            Object craftItemStack = nmsItemStackClass.getMethod("a", nbtTagCompoundClass).invoke(nmsItemStackClass, nbtTagCompound);
            itemStack = (ItemStack)Reflection.getOBC("inventory.CraftItemStack").getMethod("asBukkitCopy", nmsItemStackClass).invoke(null, craftItemStack);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return itemStack;
    }

    public static ItemMeta toggleItemFlag(ItemMeta itemMeta, ItemFlag itemFlag) {
        if (!itemMeta.hasItemFlag(itemFlag)) {
            itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
        } else {
            itemMeta.removeItemFlags(new ItemFlag[]{itemFlag});
        }
        return itemMeta;
    }

    public static ItemMeta setEnchantEffect(ItemMeta itemMeta, boolean hide) {
        if (!itemMeta.hasEnchants()) {
            itemMeta.addEnchant(Enchantment.DAMAGE_ARTHROPODS, 0, true);
            if (hide) {
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
        }
        return itemMeta;
    }

    @Deprecated
    public static ItemMeta setToItemSettings(ItemMeta itemMeta, String key, Object value) {
        List lore;
        JSONObject obj = ItemUtils.getItemSettings(itemMeta);
        List list = lore = itemMeta.hasLore() ? itemMeta.getLore() : new ArrayList();
        if (obj == null) {
            obj = new JSONObject(new HashMap());
            obj.put((Object)key, value);
            lore.add(WolfyUtilities.hideString("itemSettings" + obj.toString()));
        } else {
            obj.put((Object)key, value);
            for (int i = 0; i < lore.size(); ++i) {
                String line = WolfyUtilities.unhideString((String)lore.get(i));
                if (!line.startsWith("itemSettings")) continue;
                lore.set(i, WolfyUtilities.hideString("itemSettings" + obj.toString()));
            }
        }
        itemMeta.setLore(lore);
        return itemMeta;
    }

    @Deprecated
    public static ItemStack setToItemSettings(ItemStack itemStack, String key, Object value) {
        itemStack.setItemMeta(ItemUtils.setToItemSettings(itemStack.getItemMeta(), key, value));
        return itemStack;
    }

    public static void removeItemSettings(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemUtils.removeItemSettings(itemMeta);
        itemStack.setItemMeta(itemMeta);
    }

    public static void removeItemSettings(ItemMeta itemMeta) {
        if (itemMeta != null && itemMeta.hasLore()) {
            List lore = itemMeta.getLore();
            Iterator iterator = lore.iterator();
            while (iterator.hasNext()) {
                String cleared = WolfyUtilities.unhideString((String)iterator.next());
                if (!cleared.startsWith("itemSettings")) continue;
                iterator.remove();
            }
            itemMeta.setLore(lore);
        }
    }

    @Deprecated
    @Nullable
    public static Object getFromItemSettings(ItemMeta itemMeta, String key) {
        if (ItemUtils.hasItemSettings(itemMeta)) {
            return ItemUtils.getItemSettings(itemMeta).get((Object)key);
        }
        return null;
    }

    @Deprecated
    public static Object getFromItemSettings(ItemStack itemStack, String key) {
        return ItemUtils.getFromItemSettings(itemStack.getItemMeta(), key);
    }

    @Deprecated
    public static boolean isInItemSettings(ItemStack itemStack, String key) {
        return ItemUtils.getFromItemSettings(itemStack, key) != null;
    }

    @Deprecated
    public static boolean isInItemSettings(ItemMeta itemMeta, String key) {
        return ItemUtils.getFromItemSettings(itemMeta, key) != null;
    }

    @Deprecated
    public static boolean hasItemSettings(@Nonnull ItemStack itemStack) {
        return ItemUtils.getItemSettings(itemStack.getItemMeta()) != null;
    }

    @Deprecated
    public static boolean hasItemSettings(@Nullable ItemMeta itemMeta) {
        return ItemUtils.getItemSettings(itemMeta) != null;
    }

    @Deprecated
    public static JSONObject getItemSettings(@Nonnull ItemStack itemStack) {
        return ItemUtils.getItemSettings(itemStack.getItemMeta());
    }

    @Deprecated
    @Nullable
    public static JSONObject getItemSettings(@Nullable ItemMeta itemMeta) {
        if (itemMeta != null && itemMeta.hasLore()) {
            List lore = itemMeta.getLore();
            for (String line : lore) {
                String cleared = WolfyUtilities.unhideString(line);
                if (!cleared.startsWith("itemSettings")) continue;
                try {
                    JSONObject obj = (JSONObject)new JSONParser().parse(cleared.replace("itemSettings", ""));
                    return obj;
                }
                catch (ParseException e) {
                    Main.getMainUtil().sendConsoleWarning("Error getting JSONObject from String:");
                    Main.getMainUtil().sendConsoleWarning("" + cleared);
                    return null;
                }
            }
        }
        return null;
    }

    @Deprecated
    public static boolean hasCustomDurability(@Nonnull ItemStack itemStack) {
        return ItemUtils.hasCustomDurability(itemStack.getItemMeta());
    }

    @Deprecated
    public static boolean hasCustomDurability(@Nullable ItemMeta itemMeta) {
        JSONObject obj = ItemUtils.getItemSettings(itemMeta);
        if (obj != null) {
            return obj.keySet().contains("durability");
        }
        return false;
    }

    @Deprecated
    public static void setCustomDurability(ItemStack itemStack, int durability) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemUtils.setCustomDurability(itemMeta, durability);
        itemStack.setItemMeta(itemMeta);
    }

    @Deprecated
    public static void setCustomDurability(ItemMeta itemMeta, int durability) {
        ItemUtils.setToItemSettings(itemMeta, "durability", (Object)durability);
        ItemUtils.setDurabilityTag(itemMeta);
    }

    @Deprecated
    public static int getCustomDurability(ItemStack itemStack) {
        return ItemUtils.getCustomDurability(itemStack.getItemMeta());
    }

    @Deprecated
    public static int getCustomDurability(ItemMeta itemMeta) {
        if (ItemUtils.getFromItemSettings(itemMeta, "durability") != null) {
            return NumberConversions.toInt((Object)ItemUtils.getFromItemSettings(itemMeta, "durability"));
        }
        return 0;
    }

    @Deprecated
    public static void setDamage(ItemStack itemStack, int damage) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof Damageable) {
            ((Damageable)itemMeta).setDamage((int)((double)itemStack.getType().getMaxDurability() * ((double)damage / (double)ItemUtils.getCustomDurability(itemStack))));
        }
        ItemUtils.setDamage(itemMeta, damage);
        itemStack.setItemMeta(itemMeta);
    }

    @Deprecated
    public static void setDamage(ItemMeta itemMeta, int damage) {
        ItemUtils.setToItemSettings(itemMeta, "damage", (Object)damage);
        ItemUtils.setDurabilityTag(itemMeta);
    }

    @Deprecated
    public static int getDamage(ItemStack itemStack) {
        return ItemUtils.getDamage(itemStack.getItemMeta());
    }

    @Deprecated
    public static int getDamage(ItemMeta itemMeta) {
        if (ItemUtils.getFromItemSettings(itemMeta, "damage") != null) {
            int damage = NumberConversions.toInt((Object)ItemUtils.getFromItemSettings(itemMeta, "damage"));
            return damage;
        }
        return 0;
    }

    @Deprecated
    public static void setDurabilityTag(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemUtils.setDurabilityTag(itemMeta);
        itemStack.setItemMeta(itemMeta);
    }

    @Deprecated
    public static void setDurabilityTag(ItemMeta itemMeta) {
        if (!ItemUtils.getDurabilityTag(itemMeta).isEmpty() && !ItemUtils.getDurabilityTag(itemMeta).equals("")) {
            List lore = itemMeta.getLore() != null ? itemMeta.getLore() : new ArrayList();
            for (int i = 0; i < lore.size(); ++i) {
                String line = WolfyUtilities.unhideString((String)lore.get(i));
                if (!line.startsWith("durability_tag")) continue;
                lore.remove(i);
            }
            lore.add(lore.size() > 0 ? lore.size() - 1 : 0, WolfyUtilities.hideString("durability_tag") + WolfyUtilities.translateColorCodes(ItemUtils.getDurabilityTag(itemMeta).replace("%DUR%", String.valueOf(ItemUtils.getCustomDurability(itemMeta) - ItemUtils.getDamage(itemMeta))).replace("%MAX_DUR%", String.valueOf(ItemUtils.getCustomDurability(itemMeta)))));
            itemMeta.setLore(lore);
        }
    }

    public static void removeDurabilityTag(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemUtils.removeDurabilityTag(itemMeta);
        itemStack.setItemMeta(itemMeta);
    }

    public static void removeDurabilityTag(ItemMeta itemMeta) {
        List lore = itemMeta.getLore() != null ? itemMeta.getLore() : new ArrayList();
        for (int i = 0; i < lore.size(); ++i) {
            String line = WolfyUtilities.unhideString((String)lore.get(i));
            if (!line.startsWith("durability_tag")) continue;
            lore.remove(i);
        }
        itemMeta.setLore(lore);
    }

    @Deprecated
    public static void setDurabilityTag(ItemMeta itemMeta, String value) {
        ItemUtils.setToItemSettings(itemMeta, "durability_tag", (Object)value);
        ItemUtils.setDurabilityTag(itemMeta);
    }

    @Deprecated
    public static void setDurabilityTag(ItemStack itemStack, String value) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemUtils.setDurabilityTag(itemMeta, value);
        itemStack.setItemMeta(itemMeta);
    }

    @Deprecated
    public static String getDurabilityTag(ItemStack itemStack) {
        return ItemUtils.getDurabilityTag(itemStack.getItemMeta());
    }

    @Deprecated
    public static String getDurabilityTag(ItemMeta itemMeta) {
        if (ItemUtils.getFromItemSettings(itemMeta, "durability_tag") != null) {
            return (String)ItemUtils.getFromItemSettings(itemMeta, "durability_tag");
        }
        return "";
    }

    public static boolean isEquipable(Material material) {
        if (material.name().endsWith("_CHESTPLATE") || material.name().endsWith("_LEGGINGS") || material.name().endsWith("_HELMET") || material.name().endsWith("_BOOTS")) {
            return true;
        }
        switch (material) {
            case ELYTRA: 
            case PLAYER_HEAD: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAirOrNull(ItemStack item) {
        return item == null || item.getType().equals((Object)Material.AIR);
    }
}

