/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.custom_items;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.wolfyscript.utilities.api.custom_items.CustomItem;
import me.wolfyscript.utilities.api.custom_items.ItemConfig;
import me.wolfyscript.utilities.api.custom_items.ParticleData;
import me.wolfyscript.utilities.api.utils.NamespacedKey;
import me.wolfyscript.utilities.api.utils.Pair;
import me.wolfyscript.utilities.api.utils.particles.ParticleEffect;
import me.wolfyscript.utilities.api.utils.particles.ParticleEffects;
import me.wolfyscript.utilities.main.Main;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class CustomItems {
    private static HashMap<String, CustomItem> customItems = new HashMap();
    private static HashMap<Location, Pair<String, UUID>> storedBlocks = new HashMap();
    private static HashMap<UUID, HashMap<EquipmentSlot, UUID>> playerItemParticles = new HashMap();

    public CustomItems(Plugin plugin) {
        Bukkit.getScheduler().scheduleSyncRepeatingTask(plugin, this::save, 12000L, 12000L);
    }

    public static List<CustomItem> getCustomItems() {
        return new ArrayList<CustomItem>(customItems.values());
    }

    public static CustomItem getCustomItem(String key) {
        return CustomItems.getCustomItem(key, true);
    }

    public static CustomItem getCustomItem(String key, boolean replace) {
        if (customItems.containsKey(key) && customItems.get(key) != null) {
            if (replace) {
                return customItems.get(key).getRealItem();
            }
            return customItems.get(key).clone();
        }
        return null;
    }

    public static void addCustomItem(CustomItem item) {
        customItems.put(item.getId(), item);
    }

    public static void removeCustomItem(String id) {
        customItems.remove(id);
    }

    public static void removeCustomItem(CustomItem item) {
        customItems.remove(item.getId());
    }

    public static CustomItem getCustomItem(String key, String name) {
        return CustomItems.getCustomItem(key + ":" + name);
    }

    public static CustomItem getCustomItem(String key, String name, boolean replace) {
        return CustomItems.getCustomItem(key + ":" + name, replace);
    }

    public static void setCustomItem(ItemConfig itemConfig) {
        customItems.put(itemConfig.getId(), new CustomItem(itemConfig));
    }

    public static HashMap<EquipmentSlot, UUID> getActiveItemEffects(Player player) {
        if (!CustomItems.hasActiveItemEffects(player)) {
            playerItemParticles.put(player.getUniqueId(), new HashMap());
        }
        return playerItemParticles.get(player.getUniqueId());
    }

    public static boolean hasActiveItemEffects(Player player) {
        return playerItemParticles.containsKey(player.getUniqueId());
    }

    public static boolean hasActiveItemEffects(Player player, EquipmentSlot equipmentSlot) {
        return playerItemParticles.getOrDefault(player.getUniqueId(), new HashMap()).containsKey(equipmentSlot);
    }

    public static UUID getActiveItemEffects(Player player, EquipmentSlot equipmentSlot) {
        return (UUID)playerItemParticles.getOrDefault(player.getUniqueId(), new HashMap()).get(equipmentSlot);
    }

    public static void setActiveParticleEffect(Player player, EquipmentSlot equipmentSlot, UUID uuid) {
        if (CustomItems.hasActiveItemEffects(player, equipmentSlot)) {
            CustomItems.stopActiveParticleEffect(player, equipmentSlot);
        }
        CustomItems.getActiveItemEffects(player).put(equipmentSlot, uuid);
    }

    public static void stopActiveParticleEffect(Player player, EquipmentSlot equipmentSlot) {
        ParticleEffects.stopEffect(CustomItems.getActiveItemEffects(player, equipmentSlot));
        CustomItems.getActiveItemEffects(player).remove(equipmentSlot);
    }

    public static boolean isBlockStored(Location location) {
        if (storedBlocks.containsKey(location)) {
            return storedBlocks.containsKey(location);
        }
        for (Location location1 : storedBlocks.keySet()) {
            if (!location1.equals((Object)location)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static CustomItem getStoredBlockItem(Location location) {
        for (Map.Entry<Location, Pair<String, UUID>> entry : storedBlocks.entrySet()) {
            if (!entry.getKey().equals((Object)location)) continue;
            return CustomItems.getCustomItem(entry.getValue().getKey());
        }
        return null;
    }

    public static void setStoredBlockItem(Location location, CustomItem customItem) {
        ParticleEffects.stopEffect(CustomItems.getStoredBlockEffect(location));
        ParticleData particleData = customItem.getParticleData();
        UUID uuid = null;
        if (particleData != null) {
            NamespacedKey particle = particleData.getParticleEffect(ParticleEffect.Action.BLOCK);
            uuid = ParticleEffects.spawnEffectOnBlock(particle, location.getBlock());
        }
        storedBlocks.put(location, new Pair<String, Object>(customItem.getId(), uuid));
    }

    public static void removeStoredBlockItem(Location location) {
        ParticleEffects.stopEffect(CustomItems.getStoredBlockEffect(location));
        storedBlocks.remove(location);
    }

    @Nullable
    public static UUID getStoredBlockEffect(Location location) {
        for (Map.Entry<Location, Pair<String, UUID>> entry : storedBlocks.entrySet()) {
            if (!entry.getKey().equals((Object)location)) continue;
            return entry.getValue().getValue();
        }
        return null;
    }

    public static boolean hasStoredBlockEffect(Location location) {
        if (CustomItems.isBlockStored(location)) {
            return CustomItems.getStoredBlockEffect(location) != null;
        }
        return false;
    }

    public static void initiateMissingBlockEffects() {
        for (Map.Entry<Location, Pair<String, UUID>> entry : storedBlocks.entrySet()) {
            ParticleData particleData;
            NamespacedKey effectID;
            CustomItem customItem;
            if (CustomItems.hasStoredBlockEffect(entry.getKey()) || (customItem = CustomItems.getCustomItem(entry.getValue().getKey())) == null || customItem.getParticleData() == null || !customItem.getParticleData().containsKey((Object)ParticleEffect.Action.BLOCK) || (effectID = (particleData = customItem.getParticleData()).getParticleEffect(ParticleEffect.Action.BLOCK)) == null) continue;
            UUID uuid = ParticleEffects.spawnEffectOnBlock(effectID, entry.getKey().getBlock());
            storedBlocks.put(entry.getKey(), new Pair<String, UUID>(customItem.getId(), uuid));
        }
    }

    private static String locationToString(Location location) {
        return location.getWorld().getUID() + ";" + location.getBlockX() + ";" + location.getBlockY() + ";" + location.getBlockZ();
    }

    private static Location stringToLocation(String loc) {
        String[] args = loc.split(";");
        return new Location(Bukkit.getWorld((UUID)UUID.fromString(args[0])), (double)Integer.parseInt(args[1]), (double)Integer.parseInt(args[2]), (double)Integer.parseInt(args[3]));
    }

    public void save() {
        try {
            FileOutputStream fos = new FileOutputStream(new File(Main.getInstance().getDataFolder() + File.separator + "stored_block_items.dat"));
            BukkitObjectOutputStream oos = new BukkitObjectOutputStream((OutputStream)fos);
            HashMap<String, String> saveMap = new HashMap<String, String>();
            for (Map.Entry<Location, Pair<String, UUID>> entry : storedBlocks.entrySet()) {
                saveMap.put(CustomItems.locationToString(entry.getKey()), entry.getValue().getKey());
            }
            oos.writeObject(saveMap);
            oos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        File file = new File(Main.getInstance().getDataFolder() + File.separator + "stored_block_items.dat");
        if (file.exists()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                BukkitObjectInputStream ois = new BukkitObjectInputStream((InputStream)fis);
                try {
                    Object object = ois.readObject();
                    HashMap loadMap = (HashMap)object;
                    for (Map.Entry entry : loadMap.entrySet()) {
                        storedBlocks.put(CustomItems.stringToLocation((String)entry.getKey()), new Pair(entry.getValue(), null));
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                ois.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

