/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.custom_items;

import me.wolfyscript.utilities.api.config.Config;
import me.wolfyscript.utilities.api.config.ConfigAPI;
import me.wolfyscript.utilities.api.config.Configuration;
import me.wolfyscript.utilities.api.config.JsonConfiguration;
import me.wolfyscript.utilities.api.custom_items.CustomItem;
import me.wolfyscript.utilities.api.custom_items.CustomItems;
import org.bukkit.Material;

public class CustomConfig
extends Config {
    private String namespace;
    private String id;

    public CustomConfig(ConfigAPI configAPI, String namespace, String name, String path, String defaultPath, String defaultName, boolean override, String fileType) {
        super(configAPI, path, name, defaultPath, defaultName, fileType, override);
        this.namespace = namespace;
        this.id = namespace + ":" + name;
        if (this.getType().equals((Object)Configuration.Type.YAML)) {
            this.setSaveAfterValueSet(true);
        }
        this.setPathSeparator('.');
    }

    public CustomConfig(String jsonData, ConfigAPI configAPI, String namespace, String name, String defaultPath, String defaultName) {
        super(jsonData, configAPI, name, defaultPath, defaultName);
        this.namespace = namespace;
        this.id = namespace + ":" + name;
        this.setPathSeparator('.');
    }

    public CustomConfig(ConfigAPI configAPI, String namespace, String name, String defaultPath, String defaultName) {
        super(configAPI, name, defaultPath, defaultName);
        this.namespace = namespace;
        this.id = namespace + ":" + name;
        this.setPathSeparator('.');
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getId() {
        return this.id;
    }

    public void saveCustomItem(String path, CustomItem customItem) {
        if (customItem != null) {
            if (!customItem.getId().isEmpty() && !customItem.getId().equals("NULL")) {
                this.set(path + ".item_key", customItem.getId());
                this.set(path + ".custom_amount", customItem.getAmount() != CustomItems.getCustomItem(customItem.getId()).getAmount() ? customItem.getAmount() : 0);
            } else {
                this.setItem(path + ".item", customItem.getItemStack());
            }
        } else {
            this.setItem(path + ".item", null);
        }
    }

    public CustomItem getCustomItem(String path) {
        String id = this.getString(path + ".item_key");
        if (id != null && !id.isEmpty()) {
            int i;
            CustomItem customItem = CustomItems.getCustomItem(id);
            if (this.get(path + ".custom_amount") != null && (i = this.getInt(path + ".custom_amount")) != 0) {
                customItem.setAmount(i);
            }
            return customItem;
        }
        if (this.getItem(path + ".item") != null) {
            return new CustomItem(this.getItem(path + ".item"));
        }
        return new CustomItem(Material.AIR);
    }

    public void linkToFile(String namespace, String name, String path) {
        if (this.configuration instanceof JsonConfiguration) {
            this.namespace = namespace;
            this.setName(name);
            this.id = namespace + ":" + name;
            this.configuration.setName(this.id);
            ((JsonConfiguration)this.configuration).linkToFile(path + "/" + name);
        }
    }
}

