/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.config.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.utils.item_builder.ItemBuilder;
import me.wolfyscript.utilities.api.utils.particles.Particle;
import me.wolfyscript.utilities.api.utils.particles.ParticleEffect;
import org.bukkit.Material;

public class ParticleEffectSerialization
implements JsonSerializer<ParticleEffect>,
JsonDeserializer<ParticleEffect> {
    public ParticleEffect deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement instanceof JsonObject) {
            JsonObject object = (JsonObject)jsonElement;
            ParticleEffect resultParticleEffect = new ParticleEffect();
            Material material = object.has("item") ? Material.matchMaterial((String)object.get("item").getAsString()) : Material.FIREWORK_ROCKET;
            String name = object.get("name").getAsString();
            ArrayList<String> description = new ArrayList<String>();
            JsonArray lore = object.getAsJsonArray("description");
            for (JsonElement line : lore) {
                description.add(WolfyUtilities.translateColorCodes(line.getAsString()));
            }
            ItemBuilder itemBuilder = new ItemBuilder(material);
            itemBuilder.setDisplayName(WolfyUtilities.translateColorCodes(name));
            itemBuilder.setLore(description);
            resultParticleEffect.setIconItem(itemBuilder.create());
            if (object.has("particles")) {
                JsonArray jsonArray = object.getAsJsonArray("particles");
                for (JsonElement element : jsonArray) {
                    Particle particle;
                    if (!(element instanceof JsonObject) || (particle = (Particle)jsonDeserializationContext.deserialize(element, Particle.class)) == null) continue;
                    resultParticleEffect.addParticle(particle);
                }
            }
            if (object.has("count")) {
                resultParticleEffect.setCount(object.getAsJsonPrimitive("count").getAsInt());
            }
            if (object.has("cooldown")) {
                resultParticleEffect.setCooldown(object.getAsJsonPrimitive("cooldown").getAsInt());
            }
            if (object.has("duration")) {
                resultParticleEffect.setDuration(object.getAsJsonPrimitive("duration").getAsInt());
            }
            return resultParticleEffect;
        }
        return null;
    }

    public JsonElement serialize(ParticleEffect particleEffect, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("count", (Number)particleEffect.getCount());
        jsonObject.addProperty("duration", (Number)particleEffect.getDuration());
        jsonObject.addProperty("cooldown", (Number)particleEffect.getCooldown());
        JsonArray particles = new JsonArray();
        for (Particle particle : particleEffect.getParticles()) {
            particles.add(jsonSerializationContext.serialize((Object)particle, Particle.class));
        }
        jsonObject.add("particles", (JsonElement)particles);
        return jsonObject;
    }
}

