/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest;

import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.database.DatabaseTreasureChestItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerTreasureChestContent {
    private final TreasureChest plugin;
    private final UUID owner;
    private LoadState loadState = LoadState.NOT_LOADED;
    private ArrayList<DatabaseTreasureChestItem> items;
    private HashMap<Integer, DatabaseTreasureChestItem> itemsById;
    private ArrayList<Runnable> loadCallbacks;

    public PlayerTreasureChestContent(UUID owner, TreasureChest plugin) {
        this.plugin = plugin;
        this.owner = owner;
    }

    public void loadAsync(Runnable loadCallback) {
        if (loadCallback != null) {
            if (this.loadState == LoadState.LOADED) {
                loadCallback.run();
                return;
            }
            if (this.loadCallbacks == null) {
                this.loadCallbacks = new ArrayList();
            }
            this.loadCallbacks.add(loadCallback);
        }
        this.loadAsync();
    }

    public void loadAsync() {
        if (this.loadState != LoadState.NOT_LOADED) {
            return;
        }
        this.loadState = LoadState.LOADING;
        this.plugin.getWorkerThread().addWork(database -> {
            try {
                final ArrayList<DatabaseTreasureChestItem> loadedItems = this.plugin.getDatabase().getPlayerItems(this.owner);
                new BukkitRunnable(){

                    public void run() {
                        PlayerTreasureChestContent.this.items = new ArrayList();
                        for (DatabaseTreasureChestItem i : loadedItems) {
                            PlayerTreasureChestContent.this.items.add(i.restoreAfterDeserialization());
                        }
                        PlayerTreasureChestContent.this.itemsById = new HashMap();
                        for (DatabaseTreasureChestItem i : PlayerTreasureChestContent.this.items) {
                            PlayerTreasureChestContent.this.itemsById.put(i.getId(), i);
                        }
                        PlayerTreasureChestContent.this.loadState = LoadState.LOADED;
                        if (PlayerTreasureChestContent.this.loadCallbacks != null) {
                            for (Runnable r : PlayerTreasureChestContent.this.loadCallbacks) {
                                r.run();
                            }
                            PlayerTreasureChestContent.this.loadCallbacks = null;
                        }
                    }
                }.runTask((Plugin)this.plugin);
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not load treasure chest data for " + String.valueOf(this.owner) + ": " + String.valueOf(e), e);
            }
        });
    }

    void addItem(DatabaseTreasureChestItem item) {
        item = item.restoreAfterDeserialization();
        if (this.items == null) {
            this.items = new ArrayList();
            this.itemsById = new HashMap();
        }
        this.items.add(0, item);
        this.itemsById.put(item.getId(), item);
    }

    public boolean removeItem(int id) {
        if (this.itemsById == null) {
            return false;
        }
        DatabaseTreasureChestItem removed = this.itemsById.remove(id);
        if (removed != null) {
            this.items.remove(removed);
        }
        return true;
    }

    public boolean isEmpty() {
        return this.items == null || this.items.isEmpty();
    }

    public List<DatabaseTreasureChestItem> getItems() {
        return this.items == null ? Collections.emptyList() : Collections.unmodifiableList(this.items);
    }

    public DatabaseTreasureChestItem getItem(int id) {
        return this.itemsById.get(id);
    }

    public LoadState getLoadState() {
        return this.loadState;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public static enum LoadState {
        NOT_LOADED,
        LOADING,
        LOADED;

    }
}

