/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest;

import org.bukkit.Location;
import org.bukkit.inventory.Inventory;

public class OpenInventoryData {
    private Location location;
    private Inventory inventory;
    private int[] itemAtLocation;

    public OpenInventoryData(Location location, Inventory inventory) {
        this.location = location;
        this.inventory = inventory;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setItemAtPosition(int inventoryPosition, int itemListPosition) {
        if (this.itemAtLocation == null) {
            this.itemAtLocation = new int[inventoryPosition + 1];
        } else if (this.itemAtLocation.length <= inventoryPosition) {
            int[] temp = this.itemAtLocation;
            this.itemAtLocation = new int[inventoryPosition + 1];
            System.arraycopy(temp, 0, this.itemAtLocation, 0, temp.length);
        }
        this.itemAtLocation[inventoryPosition] = itemListPosition + 1;
    }

    public int getEntryAtPosition(int inventoryPosition) {
        if (this.itemAtLocation == null || this.itemAtLocation.length <= inventoryPosition || inventoryPosition < 0) {
            return -1;
        }
        return this.itemAtLocation[inventoryPosition] - 1;
    }

    public void removeEntryAtPositionAndShift(int inventoryPosition) {
        if (this.itemAtLocation == null || this.itemAtLocation.length <= inventoryPosition || inventoryPosition < 0) {
            return;
        }
        int old = this.itemAtLocation[inventoryPosition];
        if (old >= 0) {
            this.itemAtLocation[inventoryPosition] = -1;
            for (int i = 0; i < this.itemAtLocation.length; ++i) {
                int oldHere = this.itemAtLocation[i];
                if (oldHere <= old) continue;
                this.itemAtLocation[i] = oldHere - 1;
            }
        }
    }
}

