/*
 * Decompiled with CFR 0.152.
 */
package de.iani.playerUUIDCache;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.bukkit.BanEntry;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public final class CachedPlayer
implements OfflinePlayer {
    private final UUID uuid;
    private final String name;
    private final long lastSeen;
    private final long cacheLoadTime;
    private WeakReference<OfflinePlayer> bukkitPlayer;

    public CachedPlayer(UUID uuid, String name, long lastSeen, long cacheLoadTime) {
        Preconditions.checkNotNull((Object)uuid);
        Preconditions.checkNotNull((Object)name);
        this.uuid = uuid;
        this.name = name;
        this.lastSeen = lastSeen;
        this.cacheLoadTime = cacheLoadTime;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public long getLastLogin() {
        return this.lastSeen;
    }

    long getCacheLoadTime() {
        return this.cacheLoadTime;
    }

    public int hashCode() {
        return this.name.hashCode() + this.uuid.hashCode() + (int)this.lastSeen;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != CachedPlayer.class) {
            return false;
        }
        CachedPlayer other = (CachedPlayer)obj;
        return this.name.equalsIgnoreCase(other.name) && this.uuid.equals(other.uuid) && this.lastSeen == other.lastSeen;
    }

    private OfflinePlayer getOfflinePlayer() {
        OfflinePlayer p;
        WeakReference<OfflinePlayer> loaded = this.bukkitPlayer;
        OfflinePlayer offlinePlayer = p = loaded == null ? null : (OfflinePlayer)loaded.get();
        if (p == null) {
            p = Bukkit.getOfflinePlayer((UUID)this.uuid);
            this.bukkitPlayer = new WeakReference<OfflinePlayer>(p);
        }
        return p;
    }

    public boolean isOp() {
        return this.getOfflinePlayer().isOp();
    }

    public void setOp(boolean value) {
        this.getOfflinePlayer().setOp(value);
    }

    public Map<String, Object> serialize() {
        return this.getOfflinePlayer().serialize();
    }

    public boolean isOnline() {
        return this.getOfflinePlayer().isOnline();
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public boolean isBanned() {
        return this.getOfflinePlayer().isBanned();
    }

    public boolean isWhitelisted() {
        return this.getOfflinePlayer().isWhitelisted();
    }

    public void setWhitelisted(boolean value) {
        this.getOfflinePlayer().setWhitelisted(value);
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public long getFirstPlayed() {
        return this.getOfflinePlayer().getFirstPlayed();
    }

    @Deprecated
    public long getLastPlayed() {
        return this.getOfflinePlayer().getLastPlayed();
    }

    public boolean hasPlayedBefore() {
        return this.getOfflinePlayer().hasPlayedBefore();
    }

    @Deprecated
    public Location getBedSpawnLocation() {
        return this.getOfflinePlayer().getBedSpawnLocation();
    }

    public void incrementStatistic(Statistic statistic) throws IllegalArgumentException {
        this.getOfflinePlayer().incrementStatistic(statistic);
    }

    public void decrementStatistic(Statistic statistic) throws IllegalArgumentException {
        this.getOfflinePlayer().decrementStatistic(statistic);
    }

    public void incrementStatistic(Statistic statistic, int amount) throws IllegalArgumentException {
        this.getOfflinePlayer().incrementStatistic(statistic, amount);
    }

    public void decrementStatistic(Statistic statistic, int amount) throws IllegalArgumentException {
        this.getOfflinePlayer().decrementStatistic(statistic, amount);
    }

    public void setStatistic(Statistic statistic, int newValue) throws IllegalArgumentException {
        this.getOfflinePlayer().setStatistic(statistic, newValue);
    }

    public int getStatistic(Statistic statistic) throws IllegalArgumentException {
        return this.getOfflinePlayer().getStatistic(statistic);
    }

    public void incrementStatistic(Statistic statistic, Material material) throws IllegalArgumentException {
        this.getOfflinePlayer().incrementStatistic(statistic, material);
    }

    public void decrementStatistic(Statistic statistic, Material material) throws IllegalArgumentException {
        this.getOfflinePlayer().decrementStatistic(statistic, material);
    }

    public int getStatistic(Statistic statistic, Material material) throws IllegalArgumentException {
        return this.getOfflinePlayer().getStatistic(statistic, material);
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) throws IllegalArgumentException {
        this.getOfflinePlayer().incrementStatistic(statistic, material, amount);
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) throws IllegalArgumentException {
        this.getOfflinePlayer().decrementStatistic(statistic, material, amount);
    }

    public void setStatistic(Statistic statistic, Material material, int newValue) throws IllegalArgumentException {
        this.getOfflinePlayer().setStatistic(statistic, material, newValue);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType) throws IllegalArgumentException {
        this.getOfflinePlayer().incrementStatistic(statistic, entityType);
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType) throws IllegalArgumentException {
        this.getOfflinePlayer().decrementStatistic(statistic, entityType);
    }

    public int getStatistic(Statistic statistic, EntityType entityType) throws IllegalArgumentException {
        return this.getOfflinePlayer().getStatistic(statistic, entityType);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) throws IllegalArgumentException {
        this.getOfflinePlayer().incrementStatistic(statistic, entityType, amount);
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        this.getOfflinePlayer().decrementStatistic(statistic, entityType, amount);
    }

    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        this.getOfflinePlayer().setStatistic(statistic, entityType, newValue);
    }

    public boolean isConnected() {
        return this.getOfflinePlayer().isConnected();
    }

    public PlayerProfile getPlayerProfile() {
        return Bukkit.createProfile((UUID)this.uuid, (String)this.name);
    }

    public <E extends BanEntry<? super PlayerProfile>> E ban(String reason, Date expires, String source) {
        return (E)this.getOfflinePlayer().ban(reason, expires, source);
    }

    public <E extends BanEntry<? super PlayerProfile>> E ban(String reason, Instant expires, String source) {
        return (E)this.getOfflinePlayer().ban(reason, expires, source);
    }

    public <E extends BanEntry<? super PlayerProfile>> E ban(String reason, Duration duration, String source) {
        return (E)this.getOfflinePlayer().ban(reason, duration, source);
    }

    public Location getRespawnLocation() {
        return this.getOfflinePlayer().getRespawnLocation();
    }

    public Location getLastDeathLocation() {
        return this.getOfflinePlayer().getLastDeathLocation();
    }

    public Location getLocation() {
        return this.getOfflinePlayer().getLocation();
    }
}

