/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.listeners;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.griefcraft.bukkit.EntityBlock;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.model.Flag;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.scripting.event.LWCProtectionRegistrationPostEvent;
import io.papermc.paper.event.entity.ItemTransportingEntityValidateTargetEvent;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LWCEntityListener
implements Listener {
    private LWCPlugin plugin;
    private UUID placedArmorStandOrSpawnEggPlayer;
    private UUID placedGolemOrWitherPlayer;
    private static final BlockFace[] POSSIBLE_COPPER_CHEST_LOCATIONS = new BlockFace[]{BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};

    public LWCEntityListener(LWCPlugin plugin) {
        this.plugin = plugin;
        new BukkitRunnable(){

            public void run() {
                LWCEntityListener.this.onTick();
            }
        }.runTaskTimer((Plugin)plugin, 1L, 1L);
    }

    protected void onTick() {
        this.placedArmorStandOrSpawnEggPlayer = null;
        this.placedGolemOrWitherPlayer = null;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityPlace(EntityPlaceEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getEntity();
        this.entityCreatedByPlayer(entity, player);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onHangingPlace(HangingPlaceEvent event) {
        Player player = event.getPlayer();
        Hanging entity = event.getEntity();
        this.entityCreatedByPlayer((Entity)entity, player);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (e.useItemInHand() == Event.Result.DENY) {
            return;
        }
        ItemStack inHand = e.getItem();
        if (inHand != null && (inHand.getType() == Material.ARMOR_STAND || inHand.getType().name().endsWith("_SPAWN_EGG"))) {
            this.placedArmorStandOrSpawnEggPlayer = e.getPlayer().getUniqueId();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent e) {
        ItemStack inHand;
        ItemStack itemStack = inHand = e.getHand() == EquipmentSlot.OFF_HAND ? e.getPlayer().getInventory().getItemInOffHand() : e.getPlayer().getInventory().getItemInMainHand();
        if (inHand != null && (inHand.getType() == Material.ARMOR_STAND || inHand.getType().name().endsWith("_SPAWN_EGG"))) {
            this.placedArmorStandOrSpawnEggPlayer = e.getPlayer().getUniqueId();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent e) {
        Material blockType = e.getBlock().getType();
        if (blockType == Material.WITHER_SKELETON_SKULL || blockType == Material.CARVED_PUMPKIN || blockType == Material.JACK_O_LANTERN) {
            this.placedGolemOrWitherPlayer = e.getPlayer().getUniqueId();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockPlace(PlayerInteractEvent e) {
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK && e.hasBlock() && e.hasItem() && Tag.ITEMS_AXES.isTagged((Keyed)e.getItem().getType()) && Tag.COPPER_GOLEM_STATUES.isTagged((Keyed)e.getClickedBlock().getType())) {
            this.placedGolemOrWitherPlayer = e.getPlayer().getUniqueId();
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.MONITOR)
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        LivingEntity entity;
        Player player;
        if (this.placedArmorStandOrSpawnEggPlayer != null) {
            player = this.plugin.getServer().getPlayer(this.placedArmorStandOrSpawnEggPlayer);
            entity = e.getEntity();
            this.placedArmorStandOrSpawnEggPlayer = null;
            if (player != null && !e.isCancelled() && (e.getEntityType() == EntityType.ARMOR_STAND || e.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG) && player.getWorld().equals((Object)entity.getWorld()) && player.getLocation().distanceSquared(entity.getLocation()) <= 36.0) {
                this.entityCreatedByPlayer((Entity)entity, player);
            }
        }
        if (this.placedGolemOrWitherPlayer != null) {
            player = this.plugin.getServer().getPlayer(this.placedGolemOrWitherPlayer);
            entity = e.getEntity();
            this.placedGolemOrWitherPlayer = null;
            if (!(player == null || e.isCancelled() || e.getEntityType() != EntityType.WITHER && e.getEntityType() != EntityType.COPPER_GOLEM && e.getEntityType() != EntityType.IRON_GOLEM && e.getEntityType() != EntityType.SNOW_GOLEM || e.getSpawnReason() != CreatureSpawnEvent.SpawnReason.BUILD_IRONGOLEM && e.getSpawnReason() != CreatureSpawnEvent.SpawnReason.BUILD_COPPERGOLEM && e.getSpawnReason() != CreatureSpawnEvent.SpawnReason.REANIMATE && e.getSpawnReason() != CreatureSpawnEvent.SpawnReason.BUILD_SNOWMAN && e.getSpawnReason() != CreatureSpawnEvent.SpawnReason.BUILD_WITHER || !player.getWorld().equals((Object)entity.getWorld()) || !(player.getLocation().distanceSquared(entity.getLocation()) <= 36.0))) {
                this.entityCreatedByPlayer((Entity)entity, player);
                if (e.getEntityType() == EntityType.COPPER_GOLEM && e.getSpawnReason() == CreatureSpawnEvent.SpawnReason.BUILD_COPPERGOLEM) {
                    Location loc = e.getEntity().getLocation();
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                        Block golemPos = loc.getBlock();
                        for (BlockFace face : POSSIBLE_COPPER_CHEST_LOCATIONS) {
                            Block block = golemPos.getRelative(face);
                            if (!Tag.COPPER_CHESTS.isTagged((Keyed)block.getType())) continue;
                            this.plugin.getLWC().tryProtectPlacedBlockForPlayer(player, block, true);
                        }
                    });
                }
            }
        }
    }

    private void entityCreatedByPlayer(Entity entity, Player player) {
        Protection.Type type;
        if (!LWC.ENABLED || player == null) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        if (!lwc.isProtectable(entity)) {
            return;
        }
        String autoRegisterType = lwc.getAutoRegisterType(entity);
        if (!autoRegisterType.equalsIgnoreCase("private") && !autoRegisterType.equalsIgnoreCase("public")) {
            return;
        }
        if (!lwc.hasPermission((CommandSender)player, "lwc.create." + autoRegisterType, "lwc.create", "lwc.protect")) {
            return;
        }
        try {
            type = Protection.Type.valueOf(autoRegisterType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return;
        }
        if (type == null) {
            player.sendMessage("\u00a74LWC_INVALID_CONFIG_autoRegister");
            return;
        }
        if (this.plugin.getLWC().findProtection(entity) != null) {
            return;
        }
        Protection protection = null;
        try {
            Block entityBlock = EntityBlock.getEntityBlock(entity);
            LWCProtectionRegisterEvent evt = new LWCProtectionRegisterEvent(player, entityBlock);
            lwc.getModuleLoader().dispatchEvent(evt);
            if (evt.isCancelled()) {
                return;
            }
            protection = lwc.getPhysicalDatabase().registerEntityProtection(entity, type, entity.getWorld().getName(), player.getUniqueId().toString(), "", entityBlock.getX(), entityBlock.getY(), entityBlock.getZ());
            if (!Boolean.parseBoolean(lwc.resolveProtectionConfiguration(entityBlock, "quiet"))) {
                lwc.sendLocale((CommandSender)player, "protection.onplace.create.finalize", "type", lwc.getPlugin().getMessageParser().parseMessage(autoRegisterType.toLowerCase(), new Object[0]), "block", LWC.materialToString(entityBlock));
            }
            if (protection != null) {
                lwc.getModuleLoader().dispatchEvent(new LWCProtectionRegistrationPostEvent(protection));
            }
        }
        catch (Exception e) {
            lwc.logAndPrintInternalException(player, "ENTITY_CREATE", e, protection);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void entityInteract(EntityInteractEvent event) {
        boolean allowEntityInteract;
        Block block = event.getBlock();
        Protection protection = this.plugin.getLWC().findProtection(block.getLocation());
        if (protection != null && !(allowEntityInteract = Boolean.parseBoolean(this.plugin.getLWC().resolveProtectionConfiguration(block, "allowEntityInteract")))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void entityBreakDoor(EntityBreakDoorEvent event) {
        boolean allowEntityBreakDoor;
        Block block = event.getBlock();
        Protection protection = this.plugin.getLWC().findProtection(block.getLocation());
        if (protection != null && !(allowEntityBreakDoor = Boolean.parseBoolean(this.plugin.getLWC().resolveProtectionConfiguration(block, "allowEntityBreakDoor")))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (!LWC.ENABLED || event.isCancelled()) {
            return;
        }
        LWC lwc = LWC.getInstance();
        Iterator it = event.blockList().iterator();
        while (it.hasNext()) {
            boolean ignoreExplosions;
            Block block = (Block)it.next();
            Protection protection = this.plugin.getLWC().findProtection(block);
            if (protection == null || (ignoreExplosions = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(protection.getBlock(), "ignoreExplosions"))) || protection.hasFlag(Flag.Type.ALLOWEXPLOSIONS)) continue;
            it.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        if (event.getBlock().getType() == event.getBlockData().getMaterial()) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        if (lwc.findProtection(event.getBlock()) != null) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemTransportingEntityValidateTargetEvent(ItemTransportingEntityValidateTargetEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        if (!event.isAllowed()) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Protection entityProtection = lwc.findProtection(event.getEntity());
        Protection blockProtection = lwc.findProtection(event.getBlock());
        Material blockType = event.getBlock().getType();
        boolean isBlockSource = Tag.COPPER_CHESTS.isTagged((Keyed)blockType);
        Protection sourceProtection = null;
        Protection targetProtection = null;
        Entity sourceEntity = null;
        Entity targetEntity = null;
        if (isBlockSource) {
            sourceProtection = blockProtection;
            targetProtection = entityProtection;
            targetEntity = event.getEntity();
        } else {
            sourceProtection = entityProtection;
            targetProtection = blockProtection;
            sourceEntity = event.getEntity();
        }
        if (!lwc.checkTransferItemAllowed(sourceProtection, sourceEntity, targetProtection, targetEntity)) {
            event.setAllowed(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityAddToWorld(EntityAddToWorldEvent event) {
        this.plugin.getLWC().updateLoadedLegacyProtection(event.getEntity());
    }
}

