/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.model;

import com.griefcraft.util.StringUtil;
import com.griefcraft.util.UUIDRegistry;
import org.json.simple.JSONObject;

public class Permission {
    private String name;
    private Type type;
    private Access access = Access.PLAYER;
    private boolean isVolatile = false;

    public Permission() {
    }

    public Permission(String name) {
        this.name = name;
    }

    public Permission(String name, Type type) {
        this(name);
        this.type = type;
    }

    public Permission(String name, Type type, Access access) {
        this(name, type);
        this.access = access;
    }

    public JSONObject encodeToJSON() {
        JSONObject object = new JSONObject();
        object.put((Object)"name", (Object)this.name);
        object.put((Object)"type", (Object)this.getType().ordinal());
        object.put((Object)"rights", (Object)this.getAccess().ordinal());
        return object;
    }

    public static Permission decodeJSON(JSONObject node) {
        Permission permission = new Permission();
        Access access = Access.values()[((Long)node.get((Object)"rights")).intValue()];
        if (access.ordinal() == 0) {
            access = Access.PLAYER;
        }
        permission.setName((String)node.get((Object)"name"));
        permission.setType(Type.values()[((Long)node.get((Object)"type")).intValue()]);
        permission.setAccess(access);
        return permission;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\u00a7e");
        if (this.type == Type.PLAYER) {
            builder.append(UUIDRegistry.formatPlayerName(this.getName()));
        } else {
            builder.append(this.getName());
        }
        builder.append("\u00a7f");
        builder.append(" (");
        builder.append("\u00a72");
        builder.append((Object)this.getType());
        builder.append("\u00a7f");
        builder.append(") ");
        if (this.getAccess() == Access.ADMIN) {
            builder.append("\u00a7f");
            builder.append("(");
            builder.append("\u00a74");
            builder.append("ADMIN");
            builder.append("\u00a7f");
            builder.append(")");
        }
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public Access getAccess() {
        return this.access;
    }

    public Type getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setVolatile(boolean isVolatile) {
        this.isVolatile = isVolatile;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public static enum Access {
        NONE,
        PLAYER,
        ADMIN;


        public String toString() {
            return StringUtil.capitalizeFirstLetter(super.toString());
        }
    }

    public static enum Type {
        GROUP,
        PLAYER,
        RESERVED,
        TOWN,
        ITEM,
        REGION;


        public String toString() {
            return StringUtil.capitalizeFirstLetter(super.toString());
        }
    }
}

